/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.data.lang;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import mod.chiselsandbits.forge.platform.configuration.ForgeConfigurationManager;
import mod.chiselsandbits.platforms.core.util.constants.Constants;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigLangGenerator
implements DataProvider {
    private final DataGenerator generator;

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().m_123914_((DataProvider)new ConfigLangGenerator(event.getGenerator()));
    }

    private ConfigLangGenerator(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(@NotNull HashCache cache) throws IOException {
        ArrayList<String> langKeys = new ArrayList<String>(ForgeConfigurationManager.getInstance().getAvailableKeys());
        langKeys.sort(Comparator.comparing(s -> s.replace(".comment", "")));
        JsonObject returnValue = new JsonObject();
        for (String langKey : langKeys) {
            returnValue.addProperty("mod.chiselsandbits.config." + langKey, "");
        }
        Path configLangFolder = this.generator.m_123916_().resolve("assets/chiselsandbits/lang/config/");
        Path langPath = configLangFolder.resolve("config.json");
        DataProvider.m_123920_((Gson)Constants.DataGenerator.GSON, (HashCache)cache, (JsonElement)returnValue, (Path)langPath);
    }

    @NotNull
    public String m_6055_() {
        return "Chiseled config lang generator";
    }
}

