/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChameleonBlockModel
extends BakedModelWrapper<BakedModel> {
    protected final Map<BlockState, SimpleBakedModel> retexturedModels = new ConcurrentHashMap<BlockState, SimpleBakedModel>();

    public ChameleonBlockModel(BakedModel originalModel) {
        super(originalModel);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull IModelData extraData) {
        BlockState targetBlock = this.getTargetBlock(extraData).orElse(null);
        if (targetBlock == null || targetBlock == state || targetBlock.m_60795_()) {
            return this.originalModel.getQuads(state, side, rand, extraData);
        }
        BakedModel retexturedModel = (BakedModel)this.retexturedModels.computeIfAbsent(targetBlock, key -> {
            BakedModel targetModel = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(targetBlock);
            TextureAtlasSprite oldTexture = this.getMainTextureSprite(this.originalModel, state, rand, extraData);
            TextureAtlasSprite newTexture = targetModel != this ? this.getMainTextureSprite(targetModel, targetBlock, rand, extraData) : oldTexture;
            TextureAtlasSprite particleIcon = targetModel.getParticleIcon((IModelData)EmptyModelData.INSTANCE);
            double scale = (double)this.getMinSize(particleIcon) / (double)this.getMinSize(newTexture);
            return this.createRetexturedModel(state, rand, scale, oldTexture, newTexture);
        });
        return retexturedModel.getQuads(state, side, rand, extraData);
    }

    public TextureAtlasSprite getParticleIcon(@NotNull IModelData data) {
        return this.getTargetBlock(data).map(this.retexturedModels::get).map(model -> model.getParticleIcon(data)).orElseGet(() -> this.originalModel.getParticleIcon(data));
    }

    protected Optional<BlockState> getTargetBlock(IModelData data) {
        return data.hasProperty(Data.BLOCK_STATE) ? Optional.ofNullable((BlockState)data.getData(Data.BLOCK_STATE)) : Optional.empty();
    }

    protected int getMinSize(TextureAtlasSprite sprite) {
        int min = Math.min(sprite.m_118405_(), sprite.m_118408_());
        return Math.max(min, 1);
    }

    protected TextureAtlasSprite getMainTextureSprite(BakedModel model, BlockState state, Random rand, IModelData data) {
        Direction[] directions;
        TextureAtlasSprite mainSprite = model.getParticleIcon((IModelData)EmptyModelData.INSTANCE);
        if (model instanceof ChameleonBlockModel) {
            return mainSprite;
        }
        HashSet allSprites = new HashSet();
        HashMap culledSprites = new HashMap();
        for (Direction side : directions = Direction.values()) {
            Set sprites = model.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE).stream().map(BakedQuad::m_173410_).collect(Collectors.toSet());
            culledSprites.put(side, sprites);
            allSprites.addAll(sprites);
        }
        if (state.m_60713_(Blocks.f_50440_)) {
            return Optional.ofNullable((Set)culledSprites.get(Direction.DOWN)).flatMap(set -> set.stream().findFirst()).orElse(mainSprite);
        }
        int maxCount = 0;
        for (TextureAtlasSprite sprite : allSprites) {
            int count = 0;
            for (Direction side : directions) {
                if (!((Set)culledSprites.get(side)).contains(sprite)) continue;
                ++count;
            }
            if (count <= maxCount) continue;
            mainSprite = sprite;
            maxCount = count;
        }
        return mainSprite;
    }

    protected SimpleBakedModel createRetexturedModel(@Nullable BlockState state, @NotNull Random rand, double scale, TextureAtlasSprite oldTexture, TextureAtlasSprite newTexture) {
        List<BakedQuad> unculledFaces = this.originalModel.getQuads(state, null, rand, (IModelData)EmptyModelData.INSTANCE).stream().map(quad -> this.retextureQuad((BakedQuad)quad, oldTexture, newTexture, scale)).toList();
        EnumMap<Direction, List<BakedQuad>> culledFaces = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        for (Direction direction : Direction.values()) {
            culledFaces.put(direction, this.originalModel.getQuads(state, direction, rand, (IModelData)EmptyModelData.INSTANCE).stream().map(quad -> this.retextureQuad((BakedQuad)quad, oldTexture, newTexture, scale)).toList());
        }
        return new SimpleBakedModel(unculledFaces, culledFaces, this.originalModel.m_7541_(), this.originalModel.m_7547_(), this.originalModel.m_7539_(), newTexture, this.originalModel.m_7442_(), this.originalModel.m_7343_());
    }

    protected BakedQuad retextureQuad(BakedQuad quad, TextureAtlasSprite oldSprite, TextureAtlasSprite newSprite, double scale) {
        if (!oldSprite.equals(newSprite) && quad.m_173410_().equals(oldSprite)) {
            int[] updatedVerticies = this.updateVertices(quad.m_111303_(), quad.m_173410_(), newSprite, scale);
            return new BakedQuad(updatedVerticies, quad.m_111305_(), quad.m_111306_(), newSprite, quad.m_111307_());
        }
        return quad;
    }

    protected int[] updateVertices(int[] vertices, TextureAtlasSprite oldSprite, TextureAtlasSprite newSprite, double scale) {
        int[] updatedVertices = (int[])vertices.clone();
        VertexFormat blockFormat = DefaultVertexFormat.f_85811_;
        for (int i = 0; i < blockFormat.m_86020_(); i += blockFormat.m_86017_()) {
            double u = this.getUV(Float.intBitsToFloat(vertices[i + 4]), oldSprite.m_118409_(), oldSprite.m_118410_());
            double v = this.getUV(Float.intBitsToFloat(vertices[i + 5]), oldSprite.m_118411_(), oldSprite.m_118412_());
            updatedVertices[i + 4] = Float.floatToRawIntBits(newSprite.m_118367_(u * scale));
            updatedVertices[i + 5] = Float.floatToRawIntBits(newSprite.m_118393_(v * scale));
        }
        return updatedVertices;
    }

    protected double getUV(float uv, float uv0, float uv1) {
        return (double)(uv - uv0) * 16.0 / (double)(uv1 - uv0);
    }

    public static class Data
    implements IModelData {
        public static final ModelProperty<BlockState> BLOCK_STATE = new ModelProperty();
        protected BlockState blockState;

        public Data(BlockState blockState) {
            this.blockState = blockState;
        }

        public boolean hasProperty(ModelProperty<?> prop) {
            return prop == BLOCK_STATE;
        }

        @Nullable
        public <T> T getData(ModelProperty<T> prop) {
            return (T)(this.hasProperty(prop) ? this.blockState : null);
        }

        @Nullable
        public <T> T setData(ModelProperty<T> prop, T data) {
            if (this.hasProperty(prop)) {
                this.blockState = (BlockState)data;
                return data;
            }
            return null;
        }
    }
}

