/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class QuadTransformer
implements Function<BakedQuad, BakedQuad> {
    @Nonnull
    private final Transformation transform;
    @Nullable
    private final Int2IntFunction colorTransform;
    private BakedQuadBuilder currentQuadBuilder;
    private final IVertexConsumer transformer = this.createConsumer();

    public QuadTransformer(Transformation transform, @Nullable Int2IntFunction colorTransform) {
        this.transform = transform;
        this.colorTransform = colorTransform;
    }

    @Override
    public BakedQuad apply(BakedQuad q) {
        this.currentQuadBuilder = new BakedQuadBuilder();
        q.pipe(this.transformer);
        return this.currentQuadBuilder.build();
    }

    private IVertexConsumer createConsumer() {
        final VertexFormat format = DefaultVertexFormat.f_85811_;
        int posPos = -1;
        int normPos = -1;
        int colorPos = -1;
        for (int i = 0; i < format.m_86023_().size(); ++i) {
            if (((VertexFormatElement)format.m_86023_().get(i)).m_86048_() == VertexFormatElement.Usage.POSITION) {
                posPos = i;
                continue;
            }
            if (((VertexFormatElement)format.m_86023_().get(i)).m_86048_() == VertexFormatElement.Usage.NORMAL) {
                normPos = i;
                continue;
            }
            if (((VertexFormatElement)format.m_86023_().get(i)).m_86048_() != VertexFormatElement.Usage.COLOR) continue;
            colorPos = i;
        }
        if (posPos == -1) {
            return null;
        }
        final int posPosFinal = posPos;
        final int normPosFinal = normPos;
        final int colorPosFinal = colorPos;
        return new IVertexConsumer(){
            int tintIndex = -1;

            @Nonnull
            public VertexFormat getVertexFormat() {
                return format;
            }

            public void setQuadTint(int tint) {
                QuadTransformer.this.currentQuadBuilder.setQuadTint(tint);
                this.tintIndex = tint;
            }

            public void setQuadOrientation(@Nonnull Direction orientation) {
                Vec3i normal = orientation.m_122436_();
                Vector3f newFront = new Vector3f((float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_());
                QuadTransformer.this.transform.transformNormal(newFront);
                Direction newOrientation = Direction.m_122372_((float)newFront.m_122239_(), (float)newFront.m_122260_(), (float)newFront.m_122269_());
                QuadTransformer.this.currentQuadBuilder.setQuadOrientation(newOrientation);
            }

            public void setApplyDiffuseLighting(boolean diffuse) {
                QuadTransformer.this.currentQuadBuilder.setApplyDiffuseLighting(diffuse);
            }

            public void setTexture(@Nonnull TextureAtlasSprite texture) {
                QuadTransformer.this.currentQuadBuilder.setTexture(texture);
            }

            public void put(int element, float ... data) {
                int multiplier;
                if (element == posPosFinal && QuadTransformer.this.transform != null) {
                    Vector4f newPos = new Vector4f(data[0], data[1], data[2], 1.0f);
                    QuadTransformer.this.transform.transformPosition(newPos);
                    data = new float[]{newPos.m_123601_(), newPos.m_123615_(), newPos.m_123616_()};
                } else if (element == normPosFinal) {
                    Vector3f newNormal = new Vector3f(data[0], data[1], data[2]);
                    QuadTransformer.this.transform.transformNormal(newNormal);
                    data = new float[]{newNormal.m_122239_(), newNormal.m_122260_(), newNormal.m_122269_()};
                } else if (element == colorPosFinal && this.tintIndex != -1 && QuadTransformer.this.colorTransform != null && (multiplier = ((Integer)QuadTransformer.this.colorTransform.apply((Object)this.tintIndex)).intValue()) != 0) {
                    float r = (float)(multiplier >> 16 & 0xFF) / 255.0f;
                    float g = (float)(multiplier >> 8 & 0xFF) / 255.0f;
                    float b = (float)(multiplier & 0xFF) / 255.0f;
                    float[] oldData = data;
                    data = new float[]{oldData[0] * r, oldData[1] * g, oldData[2] * b, oldData[3]};
                }
                QuadTransformer.this.currentQuadBuilder.put(element, data);
            }
        };
    }
}

