/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.obj.GlobalTempData;
import blusunrize.immersiveengineering.client.models.obj.SpecificIEOBJModel;
import blusunrize.immersiveengineering.client.models.obj.callback.DefaultCallback;
import blusunrize.immersiveengineering.client.models.obj.callback.IEOBJCallback;
import blusunrize.immersiveengineering.client.models.obj.callback.item.ItemCallback;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.InvertingVertexBuffer;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Transformation;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import malte0811.modelsplitter.model.Group;
import malte0811.modelsplitter.model.MaterialLibrary;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.IItemRenderProperties;

public class IEOBJItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final Supplier<BlockEntityWithoutLevelRenderer> INSTANCE = Suppliers.memoize(() -> new IEOBJItemRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));
    public static final IItemRenderProperties USE_IEOBJ_RENDER = new IItemRenderProperties(){

        public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
            return INSTANCE.get();
        }
    };

    private IEOBJItemRenderer(BlockEntityRenderDispatcher p_172550_, EntityModelSet p_172551_) {
        super(p_172550_, p_172551_);
    }

    public void m_108829_(@Nonnull ItemStack stack, @Nonnull ItemTransforms.TransformType transformType, @Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderByItem(stack, transformType, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, GlobalTempData.getActiveModel());
    }

    public <T> void renderByItem(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, SpecificIEOBJModel<T> model) {
        ItemCallback callback;
        IEOBJCallback<T> baseCallback = model.getCallback();
        if (baseCallback instanceof ItemCallback) {
            ItemCallback itemCB = (ItemCallback)baseCallback;
            callback = itemCB;
        } else {
            callback = DefaultCallback.cast();
        }
        float partialTicks = ClientUtils.mc().m_91296_();
        HashSet<String> visible = new HashSet<String>();
        for (String g : model.getGroups().keySet()) {
            if (!callback.shouldRenderGroup(model.getKey(), g, null)) continue;
            visible.add(g);
        }
        LivingEntity entity = GlobalTempData.getActiveHolder();
        if (transformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
            MultiBufferSource oldBufferIn = bufferIn;
            bufferIn = type -> new InvertingVertexBuffer(4, oldBufferIn.m_6299_(type));
        }
        for (List<String> groups : callback.getSpecialGroups(stack, transformType, entity)) {
            Transformation mat = callback.getTransformForGroups(stack, groups, transformType, entity, partialTicks);
            mat.push(matrixStackIn);
            this.renderQuadsForGroups(groups, model, callback, stack, matrixStackIn, bufferIn, visible, combinedLightIn, combinedOverlayIn);
            matrixStackIn.m_85849_();
        }
        this.renderQuadsForGroups(List.copyOf(visible), model, callback, stack, matrixStackIn, bufferIn, visible, combinedLightIn, combinedOverlayIn);
    }

    private <T> void renderQuadsForGroups(List<String> groups, SpecificIEOBJModel<T> model, ItemCallback<T> callback, ItemStack stack, PoseStack matrix, MultiBufferSource buffer, Set<String> visible, int light, int overlay) {
        ArrayList<SpecificIEOBJModel.ShadedQuads> quadsByLayer = new ArrayList<SpecificIEOBJModel.ShadedQuads>();
        for (String groupName : groups) {
            Group<MaterialLibrary.OBJMaterial> group = model.getGroups().get(groupName);
            if (visible.contains(groupName) && callback.shouldRenderGroup(model.getKey(), groupName, null)) {
                quadsByLayer.addAll(model.addQuadsForGroup(groupName, group, true).stream().filter(Objects::nonNull).toList());
            }
            visible.remove(groupName);
        }
        matrix.m_85836_();
        for (SpecificIEOBJModel.ShadedQuads quadsForLayer : quadsByLayer) {
            boolean bright = callback.areGroupsFullbright(stack, groups);
            ResourceLocation atlas = InventoryMenu.f_39692_;
            Vector4f color = quadsForLayer.layer().getColor();
            RenderType baseType = bright ? IERenderTypes.getFullbrightTranslucent(atlas) : (quadsForLayer.layer().isTranslucent() || color.m_123617_() < 1.0f ? RenderType.m_110473_((ResourceLocation)atlas) : RenderType.m_110458_((ResourceLocation)atlas));
            RenderType actualType = quadsForLayer.layer().getRenderType(baseType);
            VertexConsumer builder = buffer.m_6299_(actualType);
            for (BakedQuad quad : quadsForLayer.quadsInLayer()) {
                builder.putBulkData(matrix.m_85850_(), quad, color.m_123601_(), color.m_123615_(), color.m_123616_(), color.m_123617_(), light, overlay, false);
            }
            matrix.m_85841_(1.0005f, 1.0005f, 1.0005f);
        }
        matrix.m_85849_();
    }
}

