/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CrusherBlockEntity
extends PoweredMultiblockBlockEntity<CrusherBlockEntity, CrusherRecipe>
implements IEBlockInterfaces.ISoundBE,
IEBlockInterfaces.IBlockBounds,
IEClientTickableBE {
    public float animation_barrelRotation = 0.0f;
    private Pair<BlockState, AABB> renderAABB;
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(CrusherBlockEntity::getShape);
    private final CapabilityReference<IItemHandler> output = CapabilityReference.forBlockEntityAt(this, () -> new DirectionalBlockPos(this.m_58899_().m_142082_(0, -1, 0).m_5484_(this.getFacing(), -2), this.getFacing()), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private final MultiblockCapability<IItemHandler> insertionHandler = MultiblockCapability.make(this, be -> be.insertionHandler, MultiblockPartBlockEntity::master, this.registerCapability(new PoweredMultiblockBlockEntity.MultiblockInventoryHandler_DirectProcessing(this).setProcessStacking(true)));

    public CrusherBlockEntity(BlockEntityType<CrusherBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.CRUSHER, 32000, true, type, pos, state);
    }

    @Override
    public void tickClient() {
        boolean active = this.shouldRenderAsActive();
        ImmersiveEngineering.proxy.handleTileSound(IESounds.crusher, this, active, 0.5f, 1.0f);
        if (active) {
            this.animation_barrelRotation += 18.0f;
            this.animation_barrelRotation %= 360.0f;
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.processQueue.size() > 0 && ((MultiblockProcess)this.processQueue.get(0)).getRecipe(this.getLevelNonnull()) != null) {
            this.spawnParticles(((CrusherRecipe)((MultiblockProcess)this.processQueue.get((int)0)).getRecipe((Level)this.getLevelNonnull())).input.m_43908_()[0]);
        }
    }

    public void spawnParticles(ItemStack stack) {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), (double)this.m_58899_().m_123341_() + (this.getFacing().m_122434_().equals((Object)Direction.Axis.X) ? 0.5 : 0.0), (double)this.m_58899_().m_123342_() + 2.125, (double)this.m_58899_().m_123343_() + 0.5 - (this.getFacing().m_122434_().equals((Object)Direction.Axis.X) ? 0.5 : 0.0), 8, 0.0, 0.0, 0.0, 0.0625);
            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 2.125, (double)this.m_58899_().m_123343_() + 0.5, 8, 0.0, 0.0, 0.0, 0.0625);
            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), (double)(this.m_58899_().m_123341_() + 1) - (this.getFacing().m_122434_().equals((Object)Direction.Axis.X) ? 0.5 : 0.0), (double)this.m_58899_().m_123342_() + 2.125, (double)this.m_58899_().m_123343_() + 0.5 + (this.getFacing().m_122434_().equals((Object)Direction.Axis.X) ? 0.5 : 0.0), 8, 0.0, 0.0, 0.0, 0.0625);
        }
    }

    @Override
    public AABB getRenderBoundingBox() {
        if (this.renderAABB == null || this.renderAABB.getFirst() != this.m_58900_()) {
            this.renderAABB = Pair.of((Object)this.m_58900_(), (Object)new AABB((double)(this.m_58899_().m_123341_() - (this.getFacing().m_122434_() == Direction.Axis.Z ? 2 : 1)), (double)this.m_58899_().m_123342_(), (double)(this.m_58899_().m_123343_() - (this.getFacing().m_122434_() == Direction.Axis.X ? 2 : 1)), (double)(this.m_58899_().m_123341_() + (this.getFacing().m_122434_() == Direction.Axis.Z ? 3 : 2)), (double)(this.m_58899_().m_123342_() + 3), (double)(this.m_58899_().m_123343_() + (this.getFacing().m_122434_() == Direction.Axis.X ? 3 : 2))));
        }
        return (AABB)this.renderAABB.getSecond();
    }

    public static VoxelShape getBasicShape(BlockPos posInMultiblock) {
        ImmutableSet slabs = ImmutableSet.of((Object)new BlockPos(3, 0, 2), (Object)new BlockPos(1, 0, 2), (Object)new BlockPos(0, 0, 2), (Object)new BlockPos(3, 0, 1), (Object)new BlockPos(1, 0, 1), (Object)new BlockPos(3, 0, 0), (Object[])new BlockPos[]{new BlockPos(2, 0, 0), new BlockPos(1, 0, 0), new BlockPos(0, 0, 0), new BlockPos(0, 1, 1)});
        if (slabs.contains(posInMultiblock)) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
        }
        if (new BlockPos(2, 1, 1).equals((Object)posInMultiblock)) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.75, (double)1.0);
        }
        if (new BlockPos(2, 2, 1).equals((Object)posInMultiblock)) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        if (posInMultiblock.m_123342_() > 0 && posInMultiblock.m_123341_() > 0 && posInMultiblock.m_123341_() < 4) {
            float minX = 0.0f;
            float maxX = 1.0f;
            float minZ = 0.0f;
            float maxZ = 1.0f;
            if (posInMultiblock.m_123341_() == 3) {
                minX = 0.1875f;
                maxX = 1.0f;
                minZ = 0.0f;
                maxZ = 1.0f;
            } else if (posInMultiblock.m_123341_() == 1) {
                minX = 0.0f;
                maxX = 0.8125f;
                minZ = 0.0f;
                maxZ = 1.0f;
            }
            if (posInMultiblock.m_123343_() == 2) {
                maxZ = 0.8125f;
            }
            return Shapes.m_83048_((double)minX, (double)0.0, (double)minZ, (double)maxX, (double)1.0, (double)maxZ);
        }
        if (new BlockPos(0, 1, 2).equals((Object)posInMultiblock)) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0);
        }
        return Shapes.m_83144_();
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return SHAPES.get(this.posInMultiblock, (Pair<Direction, Boolean>)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    private static List<AABB> getShape(BlockPos posInMultiblock) {
        if (posInMultiblock.m_123343_() == 1 && posInMultiblock.m_123341_() == 2) {
            return CrusherBlockEntity.getBasicShape(posInMultiblock).m_83299_();
        }
        if (new BlockPos(0, 0, 2).equals((Object)posInMultiblock)) {
            ArrayList list = Lists.newArrayList((Object[])new AABB[]{new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)});
            list.add(new AABB(0.125, 0.5, 0.625, 0.25, 1.0, 0.875));
            list.add(new AABB(0.75, 0.5, 0.625, 0.875, 1.0, 0.875));
            return list;
        }
        if (new BoundingBox(1, 1, 1, 3, 2, 1).m_71051_((Vec3i)posInMultiblock)) {
            float maxX;
            ArrayList<AABB> list = new ArrayList<AABB>(3);
            float minY = 0.5f;
            float minX = posInMultiblock.m_123341_() == 1 ? 0.4375f : 0.0f;
            float f = maxX = posInMultiblock.m_123341_() == 3 ? 0.5625f : 1.0f;
            if (posInMultiblock.m_123342_() == 1) {
                list.add(new AABB((double)minX, 0.5, 0.0, (double)maxX, 0.75, 1.0));
            } else {
                minY = 0.0f;
            }
            if (posInMultiblock.m_123341_() == 1) {
                minX = 0.1875f;
            } else {
                float f2 = minX = posInMultiblock.m_123341_() == 3 ? 0.5625f : 0.0f;
            }
            maxX = posInMultiblock.m_123341_() == 3 ? 0.8125f : (posInMultiblock.m_123341_() == 1 ? 0.4375f : 1.0f);
            list.add(new AABB((double)minX, (double)minY, 0.0, (double)maxX, 1.0, 1.0));
            return list;
        }
        if ((posInMultiblock.m_123343_() == 0 || posInMultiblock.m_123343_() == 2) && posInMultiblock.m_123342_() > 0 && posInMultiblock.m_123341_() > 0 && posInMultiblock.m_123341_() < 4) {
            float maxZ;
            boolean front = posInMultiblock.m_123343_() == 0;
            boolean right = posInMultiblock.m_123341_() == 1;
            boolean left = posInMultiblock.m_123341_() == 3;
            ArrayList<AABB> list = new ArrayList<AABB>(3);
            float minY = 0.5f;
            float minX = right ? 0.4375f : 0.0f;
            float maxX = left ? 0.5625f : 1.0f;
            float minZ = front ? 0.4375f : 0.0f;
            float f = maxZ = !front ? 0.5625f : 1.0f;
            if (posInMultiblock.m_123342_() == 1) {
                list.add(new AABB((double)minX, 0.5, (double)minZ, (double)maxX, 0.75, (double)maxZ));
            } else {
                minY = 0.0f;
            }
            minX = right ? 0.1875f : 0.0f;
            maxX = left ? 0.8125f : 1.0f;
            minZ = front ? 0.1875f : 0.5625f;
            maxZ = !front ? 0.8125f : 0.4375f;
            list.add(new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, 1.0, (double)maxZ));
            if (!ImmutableSet.of((Object)new BlockPos(2, 1, 2), (Object)new BlockPos(2, 2, 2), (Object)new BlockPos(2, 1, 0), (Object)new BlockPos(2, 2, 0)).contains((Object)posInMultiblock)) {
                minX = right ? 0.1875f : 0.5625f;
                maxX = left ? 0.8125f : 0.4375f;
                minZ = front ? 0.4375f : 0.0f;
                maxZ = !front ? 0.5625f : 1.0f;
                list.add(new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, 1.0, (double)maxZ));
                if (ImmutableSet.of((Object)new BlockPos(3, 1, 2), (Object)new BlockPos(2, 1, 2), (Object)new BlockPos(1, 1, 2), (Object)new BlockPos(3, 1, 0), (Object)new BlockPos(2, 1, 0), (Object)new BlockPos(1, 1, 0), (Object[])new BlockPos[0]).contains((Object)posInMultiblock)) {
                    minZ = front ? 0.25f : 0.5f;
                    maxZ = front ? 0.5f : 0.75f;
                    list.add(new AABB(0.25, 0.0, (double)minZ, 0.75, 0.5, (double)maxZ));
                }
            }
            return list;
        }
        if (ImmutableSet.of((Object)new BlockPos(3, 0, 2), (Object)new BlockPos(1, 0, 2), (Object)new BlockPos(3, 0, 0), (Object)new BlockPos(1, 0, 0)).contains((Object)posInMultiblock)) {
            return Utils.flipBoxes(posInMultiblock.m_123343_() == 0, posInMultiblock.m_123341_() == 3, new AABB(0.25, 0.5, 0.5, 0.5, 1.0, 0.75), new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        return CrusherBlockEntity.getBasicShape(posInMultiblock).m_83299_();
    }

    private boolean isInInput(boolean allowMiddleLayer) {
        if (this.posInMultiblock.m_123342_() == 2 || allowMiddleLayer && this.posInMultiblock.m_123342_() == 1) {
            return this.posInMultiblock.m_123341_() > 0 && this.posInMultiblock.m_123341_() < 4;
        }
        return false;
    }

    @Override
    public void onEntityCollision(Level world, Entity entity) {
        block12: {
            int consumed;
            CrusherBlockEntity master;
            block14: {
                block13: {
                    boolean bpos = this.isInInput(true);
                    if (!bpos || world.f_46443_ || !entity.m_6084_() || this.isRSDisabled()) break block12;
                    master = (CrusherBlockEntity)this.master();
                    if (master == null) {
                        return;
                    }
                    Vec3 center = Vec3.m_82512_((Vec3i)master.m_58899_()).m_82520_(0.0, 0.25, 0.0);
                    AABB crusherInternal = new AABB(center.f_82479_ - 1.0625, center.f_82480_, center.f_82481_ - 1.0625, center.f_82479_ + 1.0625, center.f_82480_ + 1.25, center.f_82481_ + 1.0625);
                    if (!entity.m_142469_().m_82381_(crusherInternal)) {
                        return;
                    }
                    if (!(entity instanceof ItemEntity)) break block13;
                    ItemEntity itemEntity = (ItemEntity)entity;
                    ItemStack stack = itemEntity.m_32055_();
                    if (stack.m_41619_()) {
                        return;
                    }
                    CrusherRecipe recipe = master.findRecipeForInsertion(stack);
                    if (recipe == null) {
                        return;
                    }
                    ItemStack displayStack = recipe.getDisplayStack(stack);
                    MultiblockProcessInWorld<CrusherRecipe> process = new MultiblockProcessInWorld<CrusherRecipe>(recipe, this::getRecipeForId, 0.5f, Utils.createNonNullItemStackListFromItemStack(displayStack));
                    if (master.addProcessToQueue(process, true, true)) {
                        master.addProcessToQueue(process, false, true);
                        stack = stack.m_41777_();
                        stack.m_41774_(displayStack.m_41613_());
                        if (stack.m_41619_()) {
                            entity.m_146870_();
                        } else {
                            itemEntity.m_32045_(stack);
                        }
                    }
                    break block12;
                }
                if (!(entity instanceof LivingEntity)) break block12;
                if (!(entity instanceof Player)) break block14;
                Player player = (Player)entity;
                if (player.m_150110_().f_35934_) break block12;
            }
            if ((consumed = master.energyStorage.extractEnergy(80, true)) > 0) {
                master.energyStorage.extractEnergy(consumed, false);
                EventHandler.crusherMap.put(entity.m_142081_(), master);
                entity.m_6469_(IEDamageSources.crusher, (float)consumed / 20.0f);
            }
        }
    }

    @Override
    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(4, 1, 1, RelativeBlockFace.UP));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(0, 1, 2));
    }

    @Override
    protected int getComparatorValueOnMaster() {
        float fill = (float)this.processQueue.size() / (float)this.getProcessQueueMaxLength();
        return Mth.m_14167_((float)(fill * 14.0f)) + (fill > 0.0f ? 1 : 0);
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(MultiblockProcess<CrusherRecipe> process) {
        return true;
    }

    @Override
    protected boolean shouldSyncProcessQueue() {
        return false;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.output, output, false)).m_41619_()) {
            Utils.dropStackAtPos(this.f_58857_, this.m_58899_().m_142082_(0, -1, 0).m_5484_(this.getFacing(), -2), output, this.getFacing().m_122424_());
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(MultiblockProcess<CrusherRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 1;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 2048;
    }

    @Override
    public float getMinProcessDistance(MultiblockProcess<CrusherRecipe> process) {
        return 0.0f;
    }

    @Override
    public int[] getCurrentProcessesStep() {
        CrusherBlockEntity master = (CrusherBlockEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        int[] ia = new int[this.processQueue.size() > 0 ? 1 : 0];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = ((MultiblockProcess)this.processQueue.get((int)i)).processTick;
        }
        return ia;
    }

    @Override
    public int[] getCurrentProcessesMax() {
        CrusherBlockEntity master = (CrusherBlockEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        int[] ia = new int[this.processQueue.size() > 0 ? 1 : 0];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = ((MultiblockProcess)this.processQueue.get(i)).getMaxTicks(this.f_58857_);
        }
        return ia;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return null;
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    public void doGraphicalUpdates() {
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.isInInput(false)) {
            return this.insertionHandler.getAndCast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public CrusherRecipe findRecipeForInsertion(ItemStack inserting) {
        return CrusherRecipe.findRecipe(this.f_58857_, inserting);
    }

    @Override
    protected CrusherRecipe getRecipeForId(Level level, ResourceLocation id) {
        return CrusherRecipe.RECIPES.getById(level, id);
    }

    @Override
    public boolean shouldPlaySound(String sound) {
        return this.shouldRenderAsActive();
    }
}

