/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computers.oc2;

import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerCallback;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerControlState;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerControllable;
import blusunrize.immersiveengineering.common.util.compat.computers.oc2.IERPCMethod;
import blusunrize.immersiveengineering.common.util.compat.computers.oc2.WrappedOwner;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import li.cil.oc2.api.bus.device.rpc.RPCDevice;
import li.cil.oc2.api.bus.device.rpc.RPCMethodGroup;

public final class IEDevice<T>
implements RPCDevice {
    private final WrappedOwner<T> owner;
    private final T value;
    private final List<RPCMethodGroup> methods;

    public IEDevice(WrappedOwner<T> owner, T value) {
        this.owner = owner;
        T preprocessed = owner.getOwner().preprocess(value);
        this.value = preprocessed;
        ArrayList<RPCMethodGroup> list = new ArrayList<RPCMethodGroup>();
        for (ComputerCallback<T> cb : owner.getMethods()) {
            list.add((RPCMethodGroup)new IERPCMethod<T>(cb, value, preprocessed));
        }
        this.methods = list;
    }

    @Nonnull
    public List<String> getTypeNames() {
        return List.of(this.owner.getOwner().getName());
    }

    @Nonnull
    public List<RPCMethodGroup> getMethodGroups() {
        return this.methods;
    }

    public void mount() {
        T t = this.value;
        if (t instanceof ComputerControllable) {
            ComputerControllable controllable = (ComputerControllable)t;
            controllable.getAllComputerControlStates().forEach(ComputerControlState::addReference);
        }
    }

    public void unmount() {
        T t = this.value;
        if (t instanceof ComputerControllable) {
            ComputerControllable controllable = (ComputerControllable)t;
            controllable.getAllComputerControlStates().forEach(ComputerControlState::removeReference);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        IEDevice that = (IEDevice)obj;
        return Objects.equals(this.owner, that.owner) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.value);
    }
}

