/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.config.value;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mcp.mobius.waila.gui.config.value.OptionValue;
import mcp.mobius.waila.overlay.DisplayHelper;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;

public class SliderOptionValue
extends OptionValue<Float> {
    public static final Predicate<String> ANY = s -> true;
    public static final Predicate<String> INTEGER = s -> s.matches("^[0-9]*$");
    public static final Predicate<String> FLOAT = s -> s.matches("[-+]?([0-9]*\\.[0-9]+|[0-9]+)") || s.endsWith(".") || s.isEmpty();
    private final Slider slider;
    private float min;
    private float max;

    public SliderOptionValue(String optionName, float value, Consumer<Float> save, float min, float max) {
        super(optionName, save);
        this.value = Float.valueOf(value);
        this.min = min;
        this.max = max;
        this.slider = new Slider(this, 0, 0, 100, 20, this.getTitle());
    }

    @Override
    protected void drawValue(PoseStack matrixStack, int entryWidth, int entryHeight, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
        this.slider.f_93620_ = x;
        this.slider.f_93621_ = y + entryHeight / 6;
        this.slider.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public AbstractWidget getListener() {
        return this.slider;
    }

    public static class Slider
    extends AbstractSliderButton {
        private final SliderOptionValue parent;

        public Slider(SliderOptionValue parent, int x, int y, int width, int height, Component message) {
            super(x, y, width, height, message, Slider.fromScaled(((Float)parent.value).floatValue(), parent.min, parent.max));
            this.parent = parent;
            this.m_5697_();
        }

        public float toScaled() {
            return this.parent.min + (this.parent.max - this.parent.min) * (float)this.f_93577_;
        }

        public static double fromScaled(float f, float min, float max) {
            return Mth.m_14036_((float)((f - min) / (max - min)), (float)0.0f, (float)1.0f);
        }

        protected void m_5695_() {
            this.parent.value = Float.valueOf(this.toScaled());
            this.parent.save();
        }

        protected void m_5697_() {
            this.m_93666_((Component)new TextComponent(DisplayHelper.dfCommas.format(this.toScaled())));
        }
    }
}

