/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.buffer;

import com.jozufozu.flywheel.backend.gl.GlObject;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.jozufozu.flywheel.backend.gl.buffer.MappedBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.MappedGlBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.PersistentGlBuffer;
import com.jozufozu.flywheel.backend.gl.versioned.GlCompat;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL20;

public abstract class GlBuffer
extends GlObject {
    protected final GlBufferType type;
    protected long capacity;
    protected int growthMargin;

    public static GlBuffer requestPersistent(GlBufferType type) {
        if (GlCompat.getInstance().bufferStorageSupported()) {
            return new PersistentGlBuffer(type);
        }
        return new MappedGlBuffer(type);
    }

    public GlBuffer(GlBufferType type) {
        this._create();
        this.type = type;
    }

    public void setGrowthMargin(int growthMargin) {
        this.growthMargin = growthMargin;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public MappedBuffer getBuffer() {
        return this.getBuffer(0L, this.capacity);
    }

    public abstract MappedBuffer getBuffer(long var1, long var3);

    public boolean ensureCapacity(long size) {
        if (size > this.capacity) {
            this.capacity = size + (long)this.growthMargin;
            this.alloc(this.capacity);
            return true;
        }
        return false;
    }

    public void doneForThisFrame() {
    }

    protected abstract void alloc(long var1);

    public abstract void upload(ByteBuffer var1);

    public void bind() {
        this.type.bind(this.handle());
    }

    public void unbind() {
        this.type.unbind();
    }

    protected void _create() {
        this.setHandle(GL20.glGenBuffers());
    }

    @Override
    protected void deleteInternal(int handle) {
        GL20.glDeleteBuffers((int)handle);
    }
}

