/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ForgeModelBakery;

public class PartialModel {
    private static final List<PartialModel> ALL = new ArrayList<PartialModel>();
    private static boolean tooLate = false;
    protected final ResourceLocation modelLocation;
    protected BakedModel bakedModel;

    public PartialModel(ResourceLocation modelLocation) {
        if (tooLate) {
            throw new RuntimeException("PartialModel '" + modelLocation + "' loaded after ModelRegistryEvent");
        }
        this.modelLocation = modelLocation;
        ALL.add(this);
    }

    public static void onModelRegistry(ModelRegistryEvent event) {
        for (PartialModel partial : ALL) {
            ForgeModelBakery.addSpecialModel((ResourceLocation)partial.getLocation());
        }
        tooLate = true;
    }

    public static void onModelBake(ModelBakeEvent event) {
        Map modelRegistry = event.getModelRegistry();
        for (PartialModel partial : ALL) {
            partial.set((BakedModel)modelRegistry.get(partial.getLocation()));
        }
    }

    protected void set(BakedModel bakedModel) {
        this.bakedModel = bakedModel;
    }

    public ResourceLocation getLocation() {
        return this.modelLocation;
    }

    public BakedModel get() {
        return this.bakedModel;
    }
}

