/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.core.model.BlockModel;
import com.jozufozu.flywheel.core.model.Bufferable;
import com.jozufozu.flywheel.core.model.ModelUtil;
import com.jozufozu.flywheel.core.virtual.VirtualEmptyBlockGetter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public final class WorldModelBuilder
implements Bufferable {
    private final RenderType layer;
    private PoseStack poseStack = new PoseStack();
    private Map<BlockPos, IModelData> modelData = Collections.emptyMap();
    private BlockAndTintGetter renderWorld = VirtualEmptyBlockGetter.INSTANCE;
    private Collection<StructureTemplate.StructureBlockInfo> blocks = Collections.emptyList();

    public WorldModelBuilder(RenderType layer) {
        this.layer = layer;
    }

    @Override
    public void bufferInto(ModelBlockRenderer modelRenderer, VertexConsumer consumer, Random random) {
        ForgeHooksClient.setRenderType((RenderType)this.layer);
        ModelBlockRenderer.m_111000_();
        for (StructureTemplate.StructureBlockInfo info : this.blocks) {
            BlockState state = info.f_74676_;
            if (state.m_60799_() != RenderShape.MODEL || !ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)this.layer)) continue;
            BlockPos pos = info.f_74675_;
            IModelData data = this.modelData.getOrDefault(pos, (IModelData)EmptyModelData.INSTANCE);
            this.poseStack.m_85836_();
            this.poseStack.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            modelRenderer.tesselateBlock(this.renderWorld, ModelUtil.VANILLA_RENDERER.m_110910_(state), state, pos, this.poseStack, consumer, true, random, 42L, OverlayTexture.f_118083_, data);
            this.poseStack.m_85849_();
        }
        ModelBlockRenderer.m_111077_();
        ForgeHooksClient.setRenderType(null);
    }

    public WorldModelBuilder withRenderWorld(BlockAndTintGetter renderWorld) {
        this.renderWorld = renderWorld;
        return this;
    }

    public WorldModelBuilder withBlocks(Collection<StructureTemplate.StructureBlockInfo> blocks) {
        this.blocks = blocks;
        return this;
    }

    public WorldModelBuilder withModelData(Map<BlockPos, IModelData> modelData) {
        this.modelData = modelData;
        return this;
    }

    public WorldModelBuilder withPoseStack(PoseStack poseStack) {
        this.poseStack = poseStack;
        return this;
    }

    public BlockModel intoMesh(String name) {
        return new BlockModel(this, name);
    }
}

