/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting.builders;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.builders.IEFinishedRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class DistillationTowerRecipeBuilder
extends IEFinishedRecipe<DistillationTowerRecipeBuilder> {
    private final List<Tuple<ItemStack, Double>> byproducts = new ArrayList<Tuple<ItemStack, Double>>();
    private static final DistillationTowerRecipeBuilder dummy = new DistillationTowerRecipeBuilder();

    public static DistillationTowerRecipeBuilder builder(FluidStack ... fluidOutput) {
        if (fluidOutput == null || fluidOutput.length == 0) {
            throw new IllegalArgumentException("Fluid output missing. It's required.");
        }
        DistillationTowerRecipeBuilder b = new DistillationTowerRecipeBuilder();
        b.addFluids("results", fluidOutput);
        return b;
    }

    private DistillationTowerRecipeBuilder() {
        super((IERecipeSerializer)Serializers.DISTILLATION_SERIALIZER.get());
        this.addWriter(jsonObject -> {
            if (this.byproducts.size() > 0) {
                JsonArray main = new JsonArray();
                this.byproducts.forEach(by -> main.add((JsonElement)DistillationTowerRecipeBuilder.serializerItemStackWithChance((Tuple<ItemStack, Double>)by)));
                jsonObject.add("byproducts", (JsonElement)main);
                this.byproducts.clear();
            }
        });
    }

    public DistillationTowerRecipeBuilder addByproduct(ItemStack byproduct, int chance) {
        return this.addByproduct(byproduct, (double)chance / 100.0);
    }

    public DistillationTowerRecipeBuilder addByproduct(ItemStack byproduct, double chance) {
        this.byproducts.add((Tuple<ItemStack, Double>)new Tuple((Object)byproduct, (Object)Math.max(Math.min(chance, 1.0), 0.0)));
        return this;
    }

    public DistillationTowerRecipeBuilder setTimeAndEnergy(int time, int energy) {
        return (DistillationTowerRecipeBuilder)((DistillationTowerRecipeBuilder)this.setTime(time)).setEnergy(energy);
    }

    public DistillationTowerRecipeBuilder addInput(TagKey<Fluid> fluidTag, int amount) {
        return (DistillationTowerRecipeBuilder)this.addFluidTag("input", fluidTag, amount);
    }

    public DistillationTowerRecipeBuilder addInput(Fluid fluid, int amount) {
        return this.addInput(new FluidStack(fluid, amount));
    }

    public DistillationTowerRecipeBuilder addInput(FluidStack fluidStack) {
        return (DistillationTowerRecipeBuilder)this.addFluid("input", fluidStack);
    }

    public DistillationTowerRecipeBuilder addFluids(String key, FluidStack ... fluidStacks) {
        return (DistillationTowerRecipeBuilder)this.addWriter(jsonObject -> {
            JsonArray array = new JsonArray();
            for (FluidStack stack : fluidStacks) {
                array.add(ApiUtils.jsonSerializeFluidStack((FluidStack)stack));
            }
            jsonObject.add(key, (JsonElement)array);
        });
    }

    public DistillationTowerRecipeBuilder addItems(String key, ItemStack ... itemStacks) {
        return (DistillationTowerRecipeBuilder)this.addWriter(jsonObject -> {
            JsonArray array = new JsonArray();
            for (ItemStack stack : itemStacks) {
                array.add((JsonElement)this.serializeItemStack(stack));
            }
            jsonObject.add(key, (JsonElement)array);
        });
    }

    public static Tuple<ItemStack, Double> deserializeItemStackWithChance(JsonObject jsonObject) {
        if (jsonObject.has("chance") && jsonObject.has("item")) {
            double chance = jsonObject.get("chance").getAsDouble();
            jsonObject.remove("chance");
            ItemStack stack = ShapedRecipe.m_151274_((JsonObject)jsonObject);
            return new Tuple((Object)stack, (Object)chance);
        }
        throw new IllegalArgumentException("Unexpected json object.");
    }

    public static JsonObject serializerItemStackWithChance(@Nonnull Tuple<ItemStack, Double> tuple) {
        JsonObject itemJson = dummy.serializeItemStack((ItemStack)tuple.m_14418_());
        itemJson.addProperty("chance", ((Double)tuple.m_14419_()).toString());
        return itemJson;
    }
}

