/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.reservoir;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;

public class IslandAxisAlignedBB {
    final int minX;
    final int minZ;
    final int maxX;
    final int maxZ;
    final BlockPos center;

    public IslandAxisAlignedBB(int minX, int minZ, int maxX, int maxZ) {
        this.minX = minX;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxZ = maxZ;
        this.center = new BlockPos((this.minX + this.maxX) / 2, 0, (this.minZ + this.maxZ) / 2);
    }

    public int minX() {
        return this.minX;
    }

    public int maxX() {
        return this.maxX;
    }

    public int minZ() {
        return this.minZ;
    }

    public int maxZ() {
        return this.maxZ;
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public boolean contains(BlockPos pos) {
        return this.contains(pos.m_123341_(), pos.m_123343_());
    }

    public boolean contains(int x, int z) {
        return x >= this.minX && x <= this.maxX && z >= this.minZ && z <= this.maxZ;
    }

    public CompoundTag writeToNBT() {
        CompoundTag bounds = new CompoundTag();
        bounds.m_128405_("minX", this.minX);
        bounds.m_128405_("minZ", this.minZ);
        bounds.m_128405_("maxX", this.maxX);
        bounds.m_128405_("maxZ", this.maxZ);
        return bounds;
    }

    public String toString() {
        return String.format("IslandAxisAlignedBB [minX = %d, minZ = %d, maxX = %d, maxZ = %d]", this.minX, this.minZ, this.maxX, this.maxZ);
    }

    public static IslandAxisAlignedBB readFromNBT(CompoundTag nbt) {
        int minX = nbt.m_128451_("minX");
        int minZ = nbt.m_128451_("minZ");
        int maxX = nbt.m_128451_("maxX");
        int maxZ = nbt.m_128451_("maxZ");
        return new IslandAxisAlignedBB(minX, minZ, maxX, maxZ);
    }
}

