/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.MultiblockBEType;
import com.google.common.collect.ImmutableSet;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import flaxbeard.immersivepetroleum.common.util.IPEffects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class IPRegisters {
    private static final DeferredRegister<Block> BLOCK_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"immersivepetroleum");
    private static final DeferredRegister<Item> ITEM_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"immersivepetroleum");
    private static final DeferredRegister<Fluid> FLUID_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"immersivepetroleum");
    private static final DeferredRegister<BlockEntityType<?>> TE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"immersivepetroleum");
    private static final DeferredRegister<EntityType<?>> ENTITY_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"immersivepetroleum");
    private static final DeferredRegister<MenuType<?>> MENU_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"immersivepetroleum");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"immersivepetroleum");
    private static final DeferredRegister<MobEffect> MOB_EFFECT = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"immersivepetroleum");

    public static void addRegistersToEventBus(IEventBus eventBus) {
        FLUID_REGISTER.register(eventBus);
        BLOCK_REGISTER.register(eventBus);
        ITEM_REGISTER.register(eventBus);
        TE_REGISTER.register(eventBus);
        ENTITY_REGISTER.register(eventBus);
        MENU_REGISTER.register(eventBus);
        RECIPE_SERIALIZERS.register(eventBus);
        MOB_EFFECT.register(eventBus);
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> blockConstructor) {
        return IPRegisters.registerBlock(name, blockConstructor, null);
    }

    public static <T extends Block> RegistryObject<T> registerMultiblockBlock(String name, Supplier<T> blockConstructor) {
        return IPRegisters.registerBlock(name, blockConstructor, block -> new BlockItem(block, new Item.Properties()));
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> blockConstructor, @Nullable Function<T, ? extends BlockItem> blockItem) {
        RegistryObject block = BLOCK_REGISTER.register(name, blockConstructor);
        if (blockItem != null) {
            IPRegisters.registerItem(name, () -> (BlockItem)blockItem.apply((Block)block.get()));
        }
        return block;
    }

    public static <T extends IPBlockBase> RegistryObject<T> registerIPBlock(String name, Supplier<T> blockConstructor) {
        RegistryObject block = BLOCK_REGISTER.register(name, blockConstructor);
        IPRegisters.registerItem(name, () -> ((IPBlockBase)((Object)((Object)block.get()))).blockItemSupplier().get());
        return block;
    }

    public static <T extends Item> RegistryObject<T> registerItem(String name, Supplier<T> itemConstructor) {
        return ITEM_REGISTER.register(name, itemConstructor);
    }

    public static <T extends Fluid> RegistryObject<T> registerFluid(String name, Supplier<T> fluidConstructor) {
        return FLUID_REGISTER.register(name, fluidConstructor);
    }

    public static <T extends Fluid> RegistryObject<T> registerFlowingFluid(String name, Supplier<T> fluidConstructor) {
        return FLUID_REGISTER.register(name, fluidConstructor);
    }

    public static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> registerTE(String name, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<? extends Block> valid) {
        return TE_REGISTER.register(name, () -> new BlockEntityType(factory, (Set)ImmutableSet.of((Object)((Block)valid.get())), null));
    }

    public static <T extends BlockEntity> MultiblockBEType<T> registerMultiblockTE(String name, MultiblockBEType.BEWithTypeConstructor<T> factory, Supplier<? extends Block> valid) {
        return new MultiblockBEType(name, TE_REGISTER, factory, valid, state -> state.m_61138_((Property)IEProperties.MULTIBLOCKSLAVE) && (Boolean)state.m_61143_((Property)IEProperties.MULTIBLOCKSLAVE) == false);
    }

    public static <T extends EntityType<?>> RegistryObject<T> registerEntity(String name, Supplier<T> entityConstructor) {
        return ENTITY_REGISTER.register(name, entityConstructor);
    }

    public static <T extends RecipeSerializer<?>> RegistryObject<T> registerSerializer(String name, Supplier<T> serializer) {
        return RECIPE_SERIALIZERS.register(name, serializer);
    }

    public static <T extends AbstractContainerMenu> RegistryObject<MenuType<T>> registerMenu(String name, Supplier<MenuType<T>> factory) {
        return MENU_REGISTER.register(name, factory);
    }

    public static <T extends IPEffects.IPEffect> RegistryObject<T> registerMobEffect(String name, Supplier<T> constructor) {
        return MOB_EFFECT.register(name, constructor);
    }

    private IPRegisters() {
    }
}

