/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common;

import com.google.common.collect.Multimap;
import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class IPSaveData
extends SavedData {
    public static final String dataName = "ImmersivePetroleum-SaveData";
    private static IPSaveData INSTANCE;

    public IPSaveData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPSaveData(CompoundTag nbt) {
        ListTag reservoirs = nbt.m_128437_("reservoirs", 10);
        if (!reservoirs.isEmpty()) {
            Multimap<ResourceKey<Level>, ReservoirIsland> mainList;
            Multimap<ResourceKey<Level>, ReservoirIsland> multimap = mainList = ReservoirHandler.getReservoirIslandList();
            synchronized (multimap) {
                ImmersivePetroleum.log.debug("[ReservoirIslands]: Clearing main list.");
                mainList.clear();
                ImmersivePetroleum.log.debug("[ReservoirIslands]: Reading...");
                for (int i = 0; i < reservoirs.size(); ++i) {
                    CompoundTag dim = reservoirs.m_128728_(i);
                    ResourceLocation rl = new ResourceLocation(dim.m_128461_("dimension"));
                    ResourceKey dimType = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)rl);
                    ListTag islands = dim.m_128437_("islands", 10);
                    ImmersivePetroleum.log.debug("[ReservoirIslands]: Read islands for dim {}", (Object)dimType.toString());
                    List list = islands.stream().map(inbt -> ReservoirIsland.readFromNBT((CompoundTag)inbt)).filter(o -> o != null).collect(Collectors.toList());
                    mainList.putAll((Object)dimType, list);
                }
                ImmersivePetroleum.log.debug("[ReservoirIslands]: Clearing Cache...");
                ReservoirHandler.clearCache();
            }
        }
        ListTag lubricatedList = nbt.m_128437_("lubricated", 10);
        LubricatedHandler.lubricatedTiles.clear();
        for (int i = 0; i < lubricatedList.size(); ++i) {
            CompoundTag tag = lubricatedList.m_128728_(i);
            LubricatedHandler.LubricatedTileInfo info = new LubricatedHandler.LubricatedTileInfo(tag);
            LubricatedHandler.lubricatedTiles.add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag nbt) {
        ListTag reservoirs = new ListTag();
        Multimap<ResourceKey<Level>, ReservoirIsland> multimap = ReservoirHandler.getReservoirIslandList();
        synchronized (multimap) {
            for (ResourceKey dimension : ReservoirHandler.getReservoirIslandList().keySet()) {
                CompoundTag dim = new CompoundTag();
                dim.m_128359_("dimension", dimension.m_135782_().toString());
                ListTag islands = new ListTag();
                for (ReservoirIsland island : ReservoirHandler.getReservoirIslandList().get((Object)dimension)) {
                    islands.add((Object)island.writeToNBT());
                }
                dim.m_128365_("islands", (Tag)islands);
                reservoirs.add((Object)dim);
            }
        }
        nbt.m_128365_("reservoirs", (Tag)reservoirs);
        ListTag lubricatedList = new ListTag();
        for (LubricatedHandler.LubricatedTileInfo info : LubricatedHandler.lubricatedTiles) {
            if (info == null) continue;
            CompoundTag tag = info.writeToNBT();
            lubricatedList.add((Object)tag);
        }
        nbt.m_128365_("lubricated", (Tag)lubricatedList);
        return nbt;
    }

    public static void markInstanceAsDirty() {
        if (INSTANCE != null) {
            INSTANCE.m_77762_();
        }
    }

    public static void setInstance(IPSaveData in) {
        INSTANCE = in;
    }
}

