/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.gui;

import flaxbeard.immersivepetroleum.api.crafting.CokerUnitRecipe;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;

public class IPSlot
extends Slot {
    public IPSlot(Container inventoryIn, int index, int xPosition, int yPosition) {
        super(inventoryIn, index, xPosition, yPosition);
    }

    public static class FluidContainer
    extends IPSlot {
        FluidFilter filter;

        public FluidContainer(Container inv, int id, int x, int y, FluidFilter filter) {
            super(inv, id, x, y);
            this.filter = filter;
        }

        public boolean m_5857_(@Nonnull ItemStack itemStack) {
            LazyOptional handlerCap = FluidUtil.getFluidHandler((ItemStack)itemStack);
            return handlerCap.map(handler -> {
                if (handler.getTanks() <= 0) {
                    return false;
                }
                return switch (this.filter) {
                    default -> throw new IncompatibleClassChangeError();
                    case FluidFilter.FULL -> !handler.getFluidInTank(0).isEmpty();
                    case FluidFilter.EMPTY -> handler.getFluidInTank(0).isEmpty();
                    case FluidFilter.ANY -> true;
                };
            }).orElse(false);
        }

        public static enum FluidFilter {
            ANY,
            EMPTY,
            FULL;

        }
    }

    public static class CokerInput
    extends IPSlot {
        public CokerInput(AbstractContainerMenu container, Container inv, int id, int x, int y) {
            super(inv, id, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return !stack.m_41619_() && CokerUnitRecipe.hasRecipeWithInput(stack, true);
        }
    }

    public static class ItemOutput
    extends IPSlot {
        public ItemOutput(Container inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return false;
        }
    }
}

