/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import com.google.common.collect.Multimap;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirType;
import flaxbeard.immersivepetroleum.client.model.IPModel;
import flaxbeard.immersivepetroleum.client.model.IPModels;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPSaveData;
import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.items.IPItemBase;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.network.MessageDebugSync;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;

public class DebugItem
extends IPItemBase {
    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        return new TextComponent("IP Debugging Tool").m_130940_(ChatFormatting.LIGHT_PURPLE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, Level worldIn, List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        tooltip.add((Component)new TextComponent("[Shift + Scroll-UP/DOWN] Change mode.").m_130940_(ChatFormatting.GRAY));
        Modes mode = DebugItem.getMode(stack);
        if (mode == Modes.DISABLED) {
            tooltip.add((Component)new TextComponent("  Disabled.").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            tooltip.add((Component)new TextComponent("  " + mode.display).m_130940_(ChatFormatting.DARK_GRAY));
        }
        tooltip.add((Component)new TextComponent("You're not supposed to have this.").m_130940_(ChatFormatting.DARK_RED));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, @Nonnull Player playerIn, @Nonnull InteractionHand handIn) {
        if (!worldIn.f_46443_) {
            Modes mode = DebugItem.getMode(playerIn.m_21120_(handIn));
            switch (mode) {
                case GENERAL_TEST: {
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(handIn));
                }
                case REFRESH_ALL_IPMODELS: {
                    try {
                        IPModels.getModels().forEach(IPModel::init);
                        playerIn.m_5661_((Component)new TextComponent("Models refreshed."), true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(handIn));
                }
                case SEEDBASED_RESERVOIR: {
                    BlockPos playerPos = playerIn.m_142538_();
                    ChunkPos cPos = new ChunkPos(playerPos);
                    int chunkX = cPos.m_45604_();
                    int chunkZ = cPos.m_45605_();
                    int x = playerPos.m_123341_() - cPos.m_45604_();
                    int z = playerPos.m_123343_() - cPos.m_45605_();
                    double noise = ReservoirHandler.getValueOf(worldIn, chunkX + x, chunkZ + z);
                    playerIn.m_5661_((Component)new TextComponent(chunkX + " " + chunkZ + ": " + noise), true);
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(handIn));
                }
                case SEEDBASED_RESERVOIR_AREA_TEST: {
                    BlockPos playerPos = playerIn.m_142538_();
                    if (ReservoirHandler.getIsland(worldIn, playerPos) != null) {
                        ReservoirIsland island = ReservoirHandler.getIsland(worldIn, playerPos);
                        int x = playerPos.m_123341_();
                        int z = playerPos.m_123343_();
                        float pressure = island.getPressure(worldIn, x, z);
                        if (playerIn.m_6144_()) {
                            island.setAmount(island.getCapacity());
                            IPSaveData.markInstanceAsDirty();
                            playerIn.m_5661_((Component)new TextComponent("Island Refilled."), true);
                            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(handIn));
                        }
                        String out = String.format(Locale.ENGLISH, "Noise: %.3f, Amount: %d/%d, Pressure: %.3f, Flow: %d, Type: %s", ReservoirHandler.getValueOf(worldIn, x, z), island.getAmount(), island.getCapacity(), Float.valueOf(pressure), ReservoirIsland.getFlow(pressure), new FluidStack(island.getFluid(), 1).getDisplayName().getString());
                        playerIn.m_5661_((Component)new TextComponent(out), true);
                    } else {
                        Multimap<ResourceKey<Level>, ReservoirIsland> islands = ReservoirHandler.getReservoirIslandList();
                        for (ResourceKey key : islands.keySet()) {
                            Collection list = islands.get((Object)key);
                            String str = key.m_135782_() + " has " + list.size() + " islands.";
                            playerIn.m_5661_((Component)new TextComponent(str), false);
                        }
                    }
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(handIn));
                }
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)playerIn.m_21120_(handIn));
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack held = player.m_21120_(context.m_43724_());
        Modes mode = DebugItem.getMode(held);
        BlockEntity te = context.m_43725_().m_7702_(context.m_8083_());
        switch (mode) {
            case GENERAL_TEST: {
                Level world = context.m_43725_();
                if (!world.f_46443_) {
                    BlockPos pos = context.m_8083_();
                    ResourceLocation dimensionRL = world.m_46472_().m_135782_();
                    ResourceLocation biomeRL = ((Biome)world.m_204166_(pos).m_203334_()).getRegistryName();
                    player.m_5661_((Component)new TextComponent(dimensionRL.toString()), false);
                    for (ReservoirType res : ReservoirType.map.values()) {
                        ReservoirType.BWList dims = res.getDimensions();
                        ReservoirType.BWList biom = res.getBiomes();
                        boolean validDimension = dims.valid(dimensionRL);
                        boolean validBiome = biom.valid(biomeRL);
                        MutableComponent component = new TextComponent(res.name).m_7220_((Component)new TextComponent(" Dimension").m_130940_(validDimension ? ChatFormatting.GREEN : ChatFormatting.RED)).m_7220_((Component)new TextComponent(" Biome").m_130940_(validBiome ? ChatFormatting.GREEN : ChatFormatting.RED));
                        if (validDimension && validBiome) {
                            component = component.m_130946_(" (can spawn here)");
                        }
                        player.m_5661_((Component)component, false);
                    }
                    Iterator<ReservoirType> iterator = ReservoirHandler.getReservoirIslandList();
                    synchronized (iterator) {
                        Collection list = ReservoirHandler.getReservoirIslandList().get((Object)world.m_46472_());
                        Vec3 playerPos = player.m_20182_();
                        double lastDistance = Double.MAX_VALUE;
                        ReservoirIsland nearestIsland = null;
                        for (ReservoirIsland res : list) {
                            BlockPos centre = res.getBoundingBox().getCenter();
                            double distance = playerPos.m_82531_((double)centre.m_123341_(), (double)centre.m_123342_(), (double)centre.m_123343_());
                            if (!(distance < lastDistance)) continue;
                            lastDistance = distance;
                            nearestIsland = res;
                        }
                        if (nearestIsland != null) {
                            BlockPos centre = nearestIsland.getBoundingBox().getCenter();
                            ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + centre.m_123341_() + " ~ " + centre.m_123343_());
                            HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("chat.coordinates.tooltip"));
                            TranslatableComponent strOut = new TranslatableComponent("chat.immersivepetroleum.command.reservoir.locate", new Object[]{nearestIsland.getType().name, ComponentUtils.m_130748_((Component)new TextComponent(centre.m_123341_() + " " + centre.m_123343_())).m_130938_(s -> s.m_131140_(ChatFormatting.GREEN).m_131155_(Boolean.valueOf(true)).m_131142_(clickEvent).m_131144_(hoverEvent))});
                            player.m_5661_((Component)strOut, false);
                        }
                    }
                }
                return InteractionResult.SUCCESS;
            }
            case UPDATE_SHAPES: {
                return InteractionResult.PASS;
            }
        }
        return InteractionResult.PASS;
    }

    public void onSpeedboatClick(MotorboatEntity speedboatEntity, Player player, ItemStack debugStack) {
        if (speedboatEntity.f_19853_.f_46443_ || DebugItem.getMode(debugStack) != Modes.INFO_SPEEDBOAT) {
            return;
        }
        TextComponent textOut = new TextComponent("-- Speedboat --\n");
        FluidStack fluid = speedboatEntity.getContainedFluid();
        if (fluid == FluidStack.EMPTY) {
            textOut.m_130946_("Tank: Empty");
        } else {
            textOut.m_130946_("Tank: " + fluid.getAmount() + "/" + speedboatEntity.getMaxFuel() + "mB of ").m_7220_(fluid.getDisplayName());
        }
        TextComponent upgradesText = new TextComponent("\n");
        NonNullList<ItemStack> upgrades = speedboatEntity.getUpgrades();
        int i = 0;
        for (ItemStack upgrade : upgrades) {
            if (upgrade == null || upgrade == ItemStack.f_41583_) {
                upgradesText.m_130946_("Upgrade " + ++i + ": Empty\n");
                continue;
            }
            upgradesText.m_130946_("Upgrade " + i++ + ": ").m_7220_(upgrade.m_41786_()).m_130946_("\n");
        }
        textOut.m_7220_((Component)upgradesText);
        player.m_6352_((Component)textOut, Util.f_137441_);
    }

    public static void setModeServer(ItemStack stack, Modes mode) {
        CompoundTag nbt = DebugItem.getSettings(stack);
        nbt.m_128405_("mode", mode.ordinal());
    }

    public static void setModeClient(ItemStack stack, Modes mode) {
        CompoundTag nbt = DebugItem.getSettings(stack);
        nbt.m_128405_("mode", mode.ordinal());
        IPPacketHandler.sendToServer(new MessageDebugSync(nbt));
    }

    public static Modes getMode(ItemStack stack) {
        CompoundTag nbt = DebugItem.getSettings(stack);
        if (nbt.m_128441_("mode")) {
            int mode = nbt.m_128451_("mode");
            if (mode < 0 || mode >= Modes.values().length) {
                mode = 0;
            }
            return Modes.values()[mode];
        }
        return Modes.DISABLED;
    }

    public static CompoundTag getSettings(ItemStack stack) {
        return stack.m_41698_("settings");
    }

    public static enum Modes {
        DISABLED("Disabled"),
        INFO_SPEEDBOAT("Info: Speedboat"),
        SEEDBASED_RESERVOIR("Seed-Based Reservoir: Heatmap"),
        SEEDBASED_RESERVOIR_AREA_TEST("Seed-Based Reservoir: Island Testing"),
        REFRESH_ALL_IPMODELS("Refresh all IPModels"),
        UPDATE_SHAPES("Does nothing without Debugging Enviroment"),
        GENERAL_TEST("This one could be dangerous to trigger!");

        public final String display;

        private Modes(String display) {
            this.display = display;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT})
    public static class ClientInputHandler {
        static boolean shiftHeld = false;

        @SubscribeEvent
        public static void handleScroll(InputEvent.MouseScrollEvent event) {
            double delta = event.getScrollDelta();
            if (shiftHeld && delta != 0.0) {
                boolean off;
                LocalPlayer player = MCUtil.getPlayer();
                ItemStack mainItem = player.m_21205_();
                ItemStack secondItem = player.m_21206_();
                boolean main = !mainItem.m_41619_() && mainItem.m_41720_() == IPContent.DEBUGITEM.get();
                boolean bl = off = !secondItem.m_41619_() && secondItem.m_41720_() == IPContent.DEBUGITEM.get();
                if (main || off) {
                    ItemStack target = main ? mainItem : secondItem;
                    Modes mode = DebugItem.getMode(target);
                    int id = mode.ordinal() + (int)delta;
                    if (id < 0) {
                        id = Modes.values().length - 1;
                    }
                    if (id >= Modes.values().length) {
                        id = 0;
                    }
                    mode = Modes.values()[id];
                    DebugItem.setModeClient(target, mode);
                    player.m_5661_((Component)new TextComponent(mode.display), true);
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void handleKey(InputEvent.KeyInputEvent event) {
            if (event.getKey() == 344 || event.getKey() == 340) {
                switch (event.getAction()) {
                    case 1: {
                        shiftHeld = true;
                        break;
                    }
                    case 0: {
                        shiftHeld = false;
                    }
                }
            }
        }
    }
}

