/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.BlockChangeDetectorBlock;
import net.geforcemods.securitycraft.inventory.BlockChangeDetectorMenu;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockChangeDetectorBlockEntity
extends DisguisableBlockEntity
implements Container,
MenuProvider,
ILockable,
ITickingBlockEntity {
    private Option.IntOption signalLength = new Option.IntOption(() -> ((BlockChangeDetectorBlockEntity)this).m_58899_(), "signalLength", 60, 5, 400, 5, true);
    private Option.IntOption range = new Option.IntOption(() -> ((BlockChangeDetectorBlockEntity)this).m_58899_(), "range", 5, 1, 15, 1, true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private DetectionMode mode = DetectionMode.BOTH;
    private boolean tracked = false;
    private List<ChangeEntry> entries = new ArrayList<ChangeEntry>();
    private final List<ChangeEntry> filteredEntries = new ArrayList<ChangeEntry>();
    private ItemStack filter = ItemStack.f_41583_;
    private boolean showHighlights = false;
    private int color = -16776961;

    public BlockChangeDetectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.BLOCK_CHANGE_DETECTOR_BLOCK_ENTITY.get(), pos, state);
    }

    public void log(Player player, DetectionMode action, BlockPos pos, BlockState state) {
        BlockItem item;
        Item item2;
        if (this.isDisabled()) {
            return;
        }
        if (this.mode != DetectionMode.BOTH && action != this.mode) {
            return;
        }
        if (this.isOwnedBy(player) && this.ignoresOwner() || this.isAllowed((Entity)player)) {
            return;
        }
        if (pos.equals((Object)this.m_58899_())) {
            return;
        }
        if (this.isModuleEnabled(ModuleType.SMART) && (item2 = this.filter.m_41720_()) instanceof BlockItem && (item = (BlockItem)item2).m_40614_() != state.m_60734_()) {
            return;
        }
        if (this.isModuleEnabled(ModuleType.REDSTONE)) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockChangeDetectorBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            BlockUtils.updateIndirectNeighbors(this.f_58857_, this.f_58858_, (Block)SCContent.BLOCK_CHANGE_DETECTOR.get());
            this.f_58857_.m_186460_(this.f_58858_, (Block)SCContent.BLOCK_CHANGE_DETECTOR.get(), ((Integer)this.signalLength.get()).intValue());
        }
        this.entries.add(new ChangeEntry(player.m_5446_().getString(), player.m_142081_(), System.currentTimeMillis(), action, pos, state));
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!this.tracked) {
            BlockEntityTracker.BLOCK_CHANGE_DETECTOR.track(this);
            this.tracked = true;
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag entryList = new ListTag();
        this.entries.stream().map(ChangeEntry::save).forEach(arg_0 -> entryList.add(arg_0));
        tag.m_128405_("mode", this.mode.ordinal());
        tag.m_128365_("entries", (Tag)entryList);
        tag.m_128365_("filter", (Tag)this.filter.m_41739_(new CompoundTag()));
        tag.m_128379_("ShowHighlights", this.showHighlights);
        tag.m_128405_("Color", this.color);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        int modeOrdinal = tag.m_128451_("mode");
        if (modeOrdinal < 0 || modeOrdinal >= DetectionMode.values().length) {
            modeOrdinal = 0;
        }
        this.mode = DetectionMode.values()[modeOrdinal];
        this.entries = new ArrayList<ChangeEntry>();
        tag.m_128437_("entries", 10).stream().map(element -> ChangeEntry.load((CompoundTag)element)).forEach(this.entries::add);
        this.filter = ItemStack.m_41712_((CompoundTag)tag.m_128469_("filter"));
        this.showHighlights = tag.m_128471_("ShowHighlights");
        this.setColor(tag.m_128451_("Color"));
        this.updateFilteredEntries();
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        BlockEntityTracker.BLOCK_CHANGE_DETECTOR.stopTracking(this);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new BlockChangeDetectorMenu(id, this.f_58857_, this.f_58858_, inventory);
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    public void setMode(DetectionMode mode) {
        this.mode = mode;
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
        }
    }

    public DetectionMode getMode() {
        return this.mode;
    }

    public int getRange() {
        return (Integer)this.range.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public List<ChangeEntry> getEntries() {
        return this.entries;
    }

    public List<ChangeEntry> getFilteredEntries() {
        return this.filteredEntries;
    }

    public void updateFilteredEntries() {
        this.filteredEntries.clear();
        this.entries.stream().filter(this::isEntryShown).forEach(this.filteredEntries::add);
    }

    public boolean isEntryShown(ChangeEntry entry) {
        DetectionMode mode = this.getMode();
        return !(mode != DetectionMode.BOTH && mode != entry.action() || !this.filter.m_41619_() && ((BlockItem)this.filter.m_41720_()).m_40614_() != entry.state.m_60734_());
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.ALLOWLIST, ModuleType.SMART, ModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.signalLength, this.range, this.disabled, this.ignoreOwner};
    }

    public void m_6211_() {
        this.filter = ItemStack.f_41583_;
        this.m_6596_();
    }

    public int m_6643_() {
        return 1;
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_7983_() {
        return this.filter.m_41619_();
    }

    public ItemStack m_8020_(int index) {
        return this.getStackInSlot(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = this.filter;
        if (count >= 1) {
            this.filter = ItemStack.f_41583_;
            this.m_6596_();
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int index) {
        ItemStack stack = this.filter;
        this.filter = ItemStack.f_41583_;
        this.m_6596_();
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (stack.m_41720_() instanceof BlockItem) {
            if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
                stack = new ItemStack((ItemLike)stack.m_41720_(), this.m_6893_());
            }
            this.filter = stack;
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (slot == 36 ? this.filter : ItemStack.f_41583_);
    }

    public void showHighlights(boolean showHighlights) {
        this.showHighlights = showHighlights;
    }

    public boolean isShowingHighlights() {
        return this.showHighlights;
    }

    public void setColor(int color) {
        this.color = Mth.m_14045_((int)color, (int)-16777216, (int)-1);
    }

    public int getColor() {
        return this.color;
    }

    public static enum DetectionMode {
        BREAK("gui.securitycraft:block_change_detector.mode.break"),
        PLACE("gui.securitycraft:block_change_detector.mode.place"),
        BOTH("gui.securitycraft:block_change_detector.mode.both");

        private String descriptionId;

        private DetectionMode(String desciptionId) {
            this.descriptionId = desciptionId;
        }

        public String getDescriptionId() {
            return this.descriptionId;
        }
    }

    public record ChangeEntry(String player, UUID uuid, long timestamp, DetectionMode action, BlockPos pos, BlockState state) {
        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("player", this.player);
            tag.m_128362_("uuid", this.uuid);
            tag.m_128356_("timestamp", this.timestamp);
            tag.m_128405_("action", this.action.ordinal());
            tag.m_128356_("pos", this.pos.m_121878_());
            tag.m_128365_("state", (Tag)NbtUtils.m_129202_((BlockState)this.state));
            return tag;
        }

        public static ChangeEntry load(CompoundTag tag) {
            int actionOrdinal = tag.m_128451_("action");
            if (actionOrdinal < 0 || actionOrdinal >= DetectionMode.values().length) {
                actionOrdinal = 0;
            }
            return new ChangeEntry(tag.m_128461_("player"), tag.m_128342_("uuid"), tag.m_128454_("timestamp"), DetectionMode.values()[actionOrdinal], BlockPos.m_122022_((long)tag.m_128454_("pos")), NbtUtils.m_129241_((CompoundTag)tag.m_128469_("state")));
        }
    }
}

