/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.ClaymoreBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClaymoreBlock
extends ExplosiveBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty DEACTIVATED = BooleanProperty.m_61465_((String)"deactivated");
    private static final VoxelShape NORTH_OFF = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)4.0, (double)7.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)5.0, (double)12.0, (double)5.0, (double)6.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)4.0, (double)4.0, (double)6.0, (double)5.0, (double)5.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)10.0, (double)4.0, (double)4.0, (double)11.0, (double)5.0, (double)5.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)3.0, (double)5.0, (double)5.0, (double)4.0), (VoxelShape)Block.m_49796_((double)11.0, (double)4.0, (double)3.0, (double)12.0, (double)5.0, (double)4.0))))));
    private static final VoxelShape NORTH_ON = Shapes.m_83110_((VoxelShape)NORTH_OFF, (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)4.0, (double)2.0, (double)4.0, (double)5.0, (double)3.0), (VoxelShape)Block.m_49796_((double)12.0, (double)4.0, (double)2.0, (double)13.0, (double)5.0, (double)3.0)));
    private static final VoxelShape EAST_OFF = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)9.0, (double)0.0, (double)4.0, (double)11.0, (double)4.0, (double)12.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)10.0, (double)4.0, (double)4.0, (double)11.0, (double)5.0, (double)12.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)11.0, (double)4.0, (double)5.0, (double)12.0, (double)5.0, (double)6.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)11.0, (double)4.0, (double)10.0, (double)12.0, (double)5.0, (double)11.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)12.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)5.0), (VoxelShape)Block.m_49796_((double)12.0, (double)4.0, (double)11.0, (double)13.0, (double)5.0, (double)12.0))))));
    private static final VoxelShape EAST_ON = Shapes.m_83110_((VoxelShape)EAST_OFF, (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)13.0, (double)4.0, (double)3.0, (double)14.0, (double)5.0, (double)4.0), (VoxelShape)Block.m_49796_((double)13.0, (double)4.0, (double)12.0, (double)14.0, (double)5.0, (double)13.0)));
    private static final VoxelShape SOUTH_OFF = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)9.0, (double)12.0, (double)4.0, (double)11.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)5.0, (double)11.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)4.0, (double)11.0, (double)6.0, (double)5.0, (double)12.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)10.0, (double)4.0, (double)11.0, (double)11.0, (double)5.0, (double)12.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)12.0, (double)5.0, (double)5.0, (double)13.0), (VoxelShape)Block.m_49796_((double)11.0, (double)4.0, (double)12.0, (double)12.0, (double)5.0, (double)13.0))))));
    private static final VoxelShape SOUTH_ON = Shapes.m_83110_((VoxelShape)SOUTH_OFF, (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)4.0, (double)13.0, (double)4.0, (double)5.0, (double)14.0), (VoxelShape)Block.m_49796_((double)12.0, (double)4.0, (double)13.0, (double)13.0, (double)5.0, (double)14.0)));
    private static final VoxelShape WEST_OFF = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)4.0, (double)7.0, (double)4.0, (double)12.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)5.0, (double)4.0, (double)4.0, (double)6.0, (double)5.0, (double)12.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)5.0, (double)5.0, (double)5.0, (double)6.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)10.0, (double)5.0, (double)5.0, (double)11.0), (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)3.0, (double)4.0, (double)4.0, (double)4.0, (double)5.0, (double)5.0), (VoxelShape)Block.m_49796_((double)3.0, (double)4.0, (double)11.0, (double)4.0, (double)5.0, (double)12.0))))));
    private static final VoxelShape WEST_ON = Shapes.m_83110_((VoxelShape)WEST_OFF, (VoxelShape)Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)4.0, (double)3.0, (double)3.0, (double)5.0, (double)4.0), (VoxelShape)Block.m_49796_((double)2.0, (double)4.0, (double)12.0, (double)3.0, (double)5.0, (double)13.0)));

    public ClaymoreBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        if (level.m_8055_(pos.m_7495_()).m_60795_()) {
            level.m_46961_(pos, true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return BlockUtils.isSideSolid(level, pos.m_7495_(), Direction.UP);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!(player.m_7500_() || level.f_46443_ || ((Boolean)level.m_8055_(pos).m_61143_((Property)DEACTIVATED)).booleanValue())) {
            level.m_46961_(pos, false);
            if (!EntityUtils.doesPlayerOwn(player, level, pos)) {
                this.explode(level, pos);
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        if (!level.f_46443_ && level.m_8055_(pos).m_61138_((Property)DEACTIVATED) && !((Boolean)level.m_8055_(pos).m_61143_((Property)DEACTIVATED)).booleanValue()) {
            if (pos.equals((Object)new BlockPos(explosion.getPosition()))) {
                return;
            }
            this.explode(level, pos);
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return this.getStateForPlacement(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_(), ctx.m_43720_().f_82479_, ctx.m_43720_().f_82480_, ctx.m_43720_().f_82481_, ctx.m_43723_());
    }

    public BlockState getStateForPlacement(Level level, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, Player placer) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placer.m_6350_())).m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public boolean activateMine(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            level.m_142346_(null, GameEvent.f_157792_, pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean defuseMine(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (!((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
            level.m_142346_(null, GameEvent.f_157792_, pos);
            return true;
        }
        return false;
    }

    @Override
    public void explode(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            level.m_46961_(pos, false);
            level.m_46518_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (Boolean)ConfigHandler.SERVER.smallerMineExplosion.get() != false ? 1.5f : 3.5f, ((Boolean)ConfigHandler.SERVER.shouldSpawnFire.get()).booleanValue(), BlockUtils.getExplosionMode());
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.m_7500_() && (blockEntity = level.m_7702_(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof IModuleInventory) {
                IModuleInventory inv = (IModuleInventory)blockEntity;
                inv.dropAllModules();
            }
            if (!newState.m_155947_()) {
                level.m_46747_(pos);
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> {
                if (((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
                    yield NORTH_OFF;
                }
                yield NORTH_ON;
            }
            case Direction.EAST -> {
                if (((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
                    yield EAST_OFF;
                }
                yield EAST_ON;
            }
            case Direction.SOUTH -> {
                if (((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
                    yield SOUTH_OFF;
                }
                yield SOUTH_ON;
            }
            case Direction.WEST -> {
                if (((Boolean)state.m_61143_((Property)DEACTIVATED)).booleanValue()) {
                    yield WEST_OFF;
                }
                yield WEST_ON;
            }
            default -> Shapes.m_83144_();
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, DEACTIVATED});
    }

    @Override
    public boolean isActive(Level level, BlockPos pos) {
        return (Boolean)level.m_8055_(pos).m_61143_((Property)DEACTIVATED) == false;
    }

    @Override
    public boolean explodesWhenInteractedWith() {
        return false;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ClaymoreBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : ClaymoreBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SCContent.CLAYMORE_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

