/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.waila;

import java.util.Optional;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.EntityAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaClientRegistration;
import mcp.mobius.waila.api.IWailaCommonRegistration;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.event.WailaRenderEvent;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.impl.Tooltip;
import mcp.mobius.waila.impl.ui.ItemStackElement;
import mcp.mobius.waila.impl.ui.TextElement;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerFieldBlock;
import net.geforcemods.securitycraft.blocks.LaserFieldBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.blocks.mines.BaseFullMineBlock;
import net.geforcemods.securitycraft.blocks.mines.FurnaceMineBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedCauldronBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPaneBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.RegistryObject;

@WailaPlugin(value="securitycraft")
public class WailaDataProvider
implements IWailaPlugin,
IComponentProvider,
IEntityComponentProvider {
    public static final WailaDataProvider INSTANCE = new WailaDataProvider();
    public static final ResourceLocation SHOW_OWNER = new ResourceLocation("securitycraft", "showowner");
    public static final ResourceLocation SHOW_MODULES = new ResourceLocation("securitycraft", "showmodules");
    public static final ResourceLocation SHOW_PASSWORDS = new ResourceLocation("securitycraft", "showpasswords");
    public static final ResourceLocation SHOW_CUSTOM_NAME = new ResourceLocation("securitycraft", "showcustomname");
    private static final Style MOD_NAME_STYLE = Style.f_131099_.m_131157_(ChatFormatting.BLUE).m_131155_(Boolean.valueOf(true));
    private static final Style ITEM_NAME_STYLE = Style.f_131099_.m_131157_(ChatFormatting.WHITE);
    private static final MutableComponent EQUIPPED = Utils.localize("waila.securitycraft:equipped", new Object[0]).m_130948_(Utils.GRAY_STYLE);
    private static final MutableComponent ALLOWLIST_MODULE = new TextComponent("- ").m_7220_((Component)new TranslatableComponent(ModuleType.ALLOWLIST.getTranslationKey())).m_130948_(Utils.GRAY_STYLE);
    private static final MutableComponent DISGUISE_MODULE = new TextComponent("- ").m_7220_((Component)new TranslatableComponent(ModuleType.DISGUISE.getTranslationKey())).m_130948_(Utils.GRAY_STYLE);
    private static final MutableComponent SPEED_MODULE = new TextComponent("- ").m_7220_((Component)new TranslatableComponent(ModuleType.SPEED.getTranslationKey())).m_130948_(Utils.GRAY_STYLE);

    public void register(IWailaCommonRegistration registration) {
        registration.addSyncedConfig(SHOW_OWNER, true);
        registration.addSyncedConfig(SHOW_MODULES, true);
        registration.addSyncedConfig(SHOW_PASSWORDS, true);
        registration.addSyncedConfig(SHOW_CUSTOM_NAME, true);
    }

    public void registerClient(IWailaClientRegistration registration) {
        for (RegistryObject registryObject : SCContent.BLOCKS.getEntries()) {
            Block block = (Block)registryObject.get();
            if (!(block instanceof OwnableBlock || block.getRegistryName().m_135815_().matches("(?!(reinforced_)).*?crystal_.*") || block instanceof ReinforcedCauldronBlock || block instanceof ReinforcedPaneBlock)) {
                registration.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.BODY, block.getClass());
            }
            if (!(block instanceof IOverlayDisplay)) continue;
            registration.usePickedResult(block);
        }
        registration.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.HEAD, BaseFullMineBlock.class);
        registration.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.HEAD, FurnaceMineBlock.class);
        registration.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.BODY, OwnableBlock.class);
        registration.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.BODY, InventoryScannerFieldBlock.class);
        registration.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.BODY, LaserFieldBlock.class);
        registration.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.BODY, ReinforcedCauldronBlock.class);
        registration.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.BODY, ReinforcedPaneBlock.class);
        registration.registerIconProvider((IComponentProvider)INSTANCE, DisguisableBlock.class);
        registration.registerIconProvider((IComponentProvider)INSTANCE, BaseFullMineBlock.class);
        registration.registerIconProvider((IComponentProvider)INSTANCE, FurnaceMineBlock.class);
        registration.registerComponentProvider((IEntityComponentProvider)INSTANCE, TooltipPosition.BODY, Sentry.class);
        registration.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.TAIL, BaseFullMineBlock.class);
        registration.registerComponentProvider((IComponentProvider)INSTANCE, TooltipPosition.TAIL, FurnaceMineBlock.class);
    }

    public IElement getIcon(BlockAccessor data, IPluginConfig config, IElement currentIcon) {
        Block block = data.getBlock();
        if (block instanceof IOverlayDisplay) {
            IOverlayDisplay display = (IOverlayDisplay)block;
            return ItemStackElement.of((ItemStack)display.getDisplayStack(data.getLevel(), data.getBlockState(), data.getPosition()));
        }
        return ItemStackElement.EMPTY;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor data, IPluginConfig config) {
        switch (data.getTooltipPosition()) {
            case HEAD: {
                if (!(tooltip instanceof Tooltip)) break;
                Tooltip head = (Tooltip)tooltip;
                ((Tooltip.Line)head.lines.get(0)).getAlignedElements(IElement.Align.LEFT).set(0, new TextElement((Component)new TranslatableComponent(((IOverlayDisplay)data.getBlock()).getDisplayStack(data.getLevel(), data.getBlockState(), data.getPosition()).m_41778_()).m_6270_(ITEM_NAME_STYLE)));
                break;
            }
            case BODY: {
                IOverlayDisplay display;
                Optional<BlockState> disguisedBlockState;
                Block block = data.getBlock();
                boolean disguised = false;
                if (block instanceof DisguisableBlock && (disguisedBlockState = DisguisableBlock.getDisguisedBlockState((BlockGetter)data.getLevel(), data.getPosition())).isPresent()) {
                    disguised = true;
                    block = disguisedBlockState.get().m_60734_();
                }
                if (block instanceof IOverlayDisplay && !(display = (IOverlayDisplay)block).shouldShowSCInfo(data.getLevel(), data.getBlockState(), data.getPosition())) {
                    return;
                }
                BlockEntity be = data.getBlockEntity();
                if (be == null) break;
                if (config.get(SHOW_OWNER) && be instanceof IOwnable) {
                    IOwnable ownable = (IOwnable)be;
                    if (block.getRegistryName().m_135827_().equals("securitycraft")) {
                        tooltip.add((Component)Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(ownable.getOwner().getName())));
                    }
                }
                if (disguised) {
                    return;
                }
                if (config.get(SHOW_MODULES) && be instanceof IModuleInventory) {
                    IOwnable ownable;
                    IModuleInventory inv = (IModuleInventory)be;
                    if (!(be instanceof IOwnable) || (ownable = (IOwnable)be).isOwnedBy(data.getPlayer())) {
                        if (!inv.getInsertedModules().isEmpty()) {
                            tooltip.add((Component)EQUIPPED);
                        }
                        for (ModuleType module : inv.getInsertedModules()) {
                            tooltip.add((Component)new TextComponent("- ").m_7220_((Component)new TranslatableComponent(module.getTranslationKey())));
                        }
                    }
                }
                if (!config.get(SHOW_PASSWORDS) || !(be instanceof IPasswordProtected)) break;
                IPasswordProtected ipp = (IPasswordProtected)be;
                if (!((IOwnable)be).isOwnedBy(data.getPlayer())) break;
                String password = ipp.getPassword();
                tooltip.add((Component)Utils.localize("waila.securitycraft:password", password != null && !password.isEmpty() ? password : Utils.localize("waila.securitycraft:password.notSet", new Object[0])));
                break;
            }
            case TAIL: {
                if (!(tooltip instanceof Tooltip)) break;
                Tooltip tail = (Tooltip)tooltip;
                ItemStack disguisedAs = ((IOverlayDisplay)data.getBlock()).getDisplayStack(data.getLevel(), data.getBlockState(), data.getPosition());
                MutableComponent modName = new TextComponent(((ModContainer)ModList.get().getModContainerById(disguisedAs.m_41720_().getRegistryName().m_135827_()).get()).getModInfo().getDisplayName()).m_6270_(MOD_NAME_STYLE);
                ((Tooltip.Line)tail.lines.get(tail.lines.size() - 1)).getAlignedElements(IElement.Align.LEFT).set(0, new TextElement((Component)modName));
            }
        }
    }

    public void appendTooltip(ITooltip tooltip, EntityAccessor data, IPluginConfig config) {
        Entity entity;
        if (data.getTooltipPosition() == TooltipPosition.BODY && (entity = data.getEntity()) instanceof Sentry) {
            Sentry sentry = (Sentry)entity;
            Sentry.SentryMode mode = sentry.getMode();
            if (config.get(SHOW_OWNER)) {
                tooltip.add((Component)Utils.localize("waila.securitycraft:owner", PlayerUtils.getOwnerComponent(sentry.getOwner().getName())));
            }
            if (config.get(SHOW_MODULES) && sentry.isOwnedBy(data.getPlayer()) && (!sentry.getAllowlistModule().m_41619_() || !sentry.getDisguiseModule().m_41619_() || sentry.hasSpeedModule())) {
                tooltip.add((Component)EQUIPPED);
                if (!sentry.getAllowlistModule().m_41619_()) {
                    tooltip.add((Component)ALLOWLIST_MODULE);
                }
                if (!sentry.getDisguiseModule().m_41619_()) {
                    tooltip.add((Component)DISGUISE_MODULE);
                }
                if (sentry.hasSpeedModule()) {
                    tooltip.add((Component)SPEED_MODULE);
                }
            }
            TranslatableComponent modeDescription = Utils.localize(mode.getModeKey(), new Object[0]);
            if (mode != Sentry.SentryMode.IDLE) {
                modeDescription.m_130946_("- ").m_7220_((Component)Utils.localize(mode.getTargetKey(), new Object[0]));
            }
            tooltip.add((Component)modeDescription);
        }
    }

    public static void onWailaRender(WailaRenderEvent.Pre event) {
        if (ClientHandler.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    static {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(WailaDataProvider::onWailaRender);
        }
    }
}

