/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BiomeId {
    public static final BiomeId EMPTY = new BiomeId(Optional.empty());
    protected final Optional<ResourceKey<Biome>> key;

    protected BiomeId(Optional<ResourceKey<Biome>> resourceKey) {
        this.key = resourceKey;
    }

    public static BiomeId from(ResourceKey<Biome> resourceKey) {
        return new BiomeId(Optional.of(resourceKey));
    }

    public static BiomeId from(LevelAccessor level, BlockPos pos) {
        Optional resourceKey = level.m_204166_(pos).m_203543_();
        return new BiomeId(resourceKey);
    }

    public static BiomeId from(ResourceLocation location) {
        Optional<ResourceKey<Biome>> resourceKey = ForgeRegistries.BIOMES.getHolder(location).flatMap(Holder::m_203543_);
        return new BiomeId(resourceKey);
    }

    public boolean isEmpty() {
        return this.getKey().isEmpty();
    }

    public Optional<ResourceKey<Biome>> getKey() {
        return this.key;
    }

    public Optional<ResourceLocation> getResourceLocation() {
        return this.getKey().map(ResourceKey::m_135782_);
    }

    public Optional<Biome> getBiome() {
        return this.getResourceLocation().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).getValue(arg_0));
    }

    public String toString() {
        return this.getResourceLocation().map(ResourceLocation::toString).orElse(super.toString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof BiomeId) {
            return Objects.equals(this.getKey(), ((BiomeId)obj).getKey());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getKey());
    }
}

