/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.impacts.AbstractPollutionImpacts;
import com.endertech.minecraft.mods.adpother.init.Sources;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EntityEvents {
    static final GameTime UPDATE_INTERVAL = GameTime.second();

    @SubscribeEvent
    public static void canEntityUpdate(EntityEvent.CanUpdate event) {
        if (event.getEntity() instanceof GasEntity && !event.getCanUpdate()) {
            event.setCanUpdate(true);
        }
    }

    @SubscribeEvent
    public static void onLivingEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity living = event.getEntityLiving();
        Level world = living.f_19853_;
        if (!GameWorld.isServerSide((LevelReader)world)) {
            return;
        }
        if (!UPDATE_INTERVAL.pastIn(world)) {
            return;
        }
        EntityPollution pollution = WorldData.getEntityPollution((Entity)living);
        int combinedDamage = pollution.getInfos().map(info -> info.getPollutant()).mapToInt(pollutant -> {
            int damage = pollution.getDamageFrom((Pollutant<?>)((Object)pollutant));
            Map<ItemStack, IStorageItem> protectItems = pollutant.getProtectiveItems(living);
            if (protectItems.isEmpty()) {
                if (!EntityEvents.killWeakLiving(living, damage)) {
                    AbstractPollutionImpacts.ImpactType impact = pollution.getImpactType((Pollutant<?>)((Object)pollutant));
                    Percentage influence = pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant));
                    pollutant.tryAffectEntity((Entity)living, impact, influence);
                }
            } else {
                protectItems.forEach((stack, item) -> item.fill(stack, (Pollutant<?>)((Object)pollutant), damage));
            }
            return damage;
        }).sum();
        AdPother.getInstance().respirators.updateEffectFor(living, combinedDamage);
    }

    static boolean killWeakLiving(LivingEntity living, int damage) {
        if (ForgeEntity.isHostileMob((Entity)living)) {
            return false;
        }
        float health = living.m_21223_();
        if (ForgeEntity.isServerSide((Entity)living) && health <= (float)damage && !(living instanceof Player)) {
            living.m_6469_(DamageSource.f_19320_, (float)damage);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onCreatureJoinWorld(EntityJoinWorldEvent event) {
        PathfinderMob creature = EntityEvents.getServerEntityOf(PathfinderMob.class, (EntityEvent)event).orElse(null);
        if (creature == null) {
            return;
        }
        if (ForgeEntity.isHostileMob((Entity)creature)) {
            return;
        }
        if (creature instanceof AgeableMob) {
            EntityPollution pollution = WorldData.getEntityPollution((Entity)creature);
            pollution.getPollutants().filter(pollutant -> AdPother.getInstance().impacts.livingImpacts.get().getActiveEffectsFor((Entity)creature, (Pollutant<?>)((Object)pollutant), AbstractPollutionImpacts.ImpactType.AIR, pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant))).stream().anyMatch(entityEffect -> entityEffect.effect.m_19483_() == MobEffectCategory.HARMFUL)).max(Comparator.comparing(pollution::getInfluenceOf)).ifPresent(pollutant -> {
                float factor = pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant)).toFraction();
                Optional.ofNullable(creature.m_21051_(Attributes.f_22276_)).ifPresent(attribute -> {
                    double baseHealth = attribute.m_22115_();
                    int newHealth = IntBounds.between((Integer)1, (Integer)((int)baseHealth)).interpolateDown(factor);
                    attribute.m_22100_((double)newHealth);
                });
            });
        }
    }

    static <T extends Entity> Optional<T> getServerEntityOf(Class<T> clazz, EntityEvent event) {
        Entity entity = event.getEntity();
        if (clazz.isInstance(entity) && EntityEvents.isServerSide(event)) {
            return Optional.of((Entity)clazz.cast(entity));
        }
        return Optional.empty();
    }

    static boolean isServerSide(EntityEvent event) {
        return !event.isCanceled() && ForgeEntity.isServerSide((Entity)event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingHeal(LivingHealEvent event) {
        EntityEvents.getServerEntityOf(Animal.class, (EntityEvent)event).ifPresent(animal -> {
            float health = animal.m_21223_();
            if (health < animal.m_21233_() && health + event.getAmount() >= animal.m_21233_()) {
                AdPother.getInstance().sources.animalFeeding.get().emitFrom(animal, 1.0f);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        if (!event.getSource().m_19384_()) {
            return;
        }
        Sources sources = AdPother.getInstance().sources;
        EntityEvents.getServerEntityOf(Mob.class, (EntityEvent)event).ifPresent(mob -> {
            if (ForgeEntity.isHostileMob((Entity)mob)) {
                sources.hostileMobDeath.get().emitFrom((Mob)mob, 1.0f);
            } else {
                sources.animalDeath.get().emitFrom((Mob)mob, 1.0f);
            }
        });
    }
}

