/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.units.UnitsInitWithEnum;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.blocks.Carbon;
import com.endertech.minecraft.mods.adpother.blocks.Dust;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.blocks.Sulfur;
import com.endertech.minecraft.mods.adpother.blocks.UserGas;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.util.Lazy;

public class Pollutants
extends UnitsInitWithEnum<Pollutant<?>, BuiltIn> {
    public Pollutants(AbstractForgeMod mod) {
        super(mod, BuiltIn.class);
    }

    public Supplier<Pollutant<?>> createDefaultUnitFrom(UnitConfig config, BuiltIn e) {
        e.pollutant = Lazy.of(() -> e.factory.create(this.getMod(), config, e.getName()));
        return e.pollutant;
    }

    public Supplier<Pollutant<?>> createCustomUnitFrom(UnitConfig config, String name) {
        return () -> new UserGas(this.getMod(), config, (AbstractGas.Properties)((Object)((Object)((Pollutant.Properties)((Object)((Object)((AbstractGas.Properties)((Object)((Object)((AbstractGas.Properties)((Object)((Object)((AbstractGas.Properties)((Object)((Object)AbstractGas.Properties.of(name, MaterialColor.f_76422_).criticalAmount(512)))).concentrationAltitude(191)))).motionVelocity(0.15f)))).absorbtionChance(50)))).textColor(ChatFormatting.DARK_PURPLE))));
    }

    public Optional<Pollutant<?>> findBy(String name) {
        return this.streamAll().filter(p -> p.getRegistryName().m_135815_().equalsIgnoreCase(name)).findFirst();
    }

    public void reloadConfigs() {
        this.getMod().getLogger().error("Unable to reload configs for pollutants because they are registered blocks");
    }

    public static enum BuiltIn implements IForgeEnum
    {
        CARBON(Carbon::new),
        SULFUR(Sulfur::new),
        DUST(Dust::new);

        private final IFactory<?> factory;
        private Lazy<Pollutant<?>> pollutant;

        private BuiltIn(IFactory<?> factory) {
            this.factory = factory;
        }

        public Pollutant<?> get() {
            return (Pollutant)((Object)this.pollutant.get());
        }
    }

    static interface IFactory<T extends Pollutant<?>> {
        public T create(AbstractForgeMod var1, UnitConfig var2, String var3);
    }
}

