/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.emissions.Emission;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.pollution.AbstractPollution;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;

public class ChunkPollution
extends AbstractPollution {
    private final ChunkLoc location;
    private boolean unloaded = false;

    public ChunkPollution(ChunkLoc location) {
        this.location = location;
    }

    public void increaseBy(Emitter emitter, IEmitter.Type type, ServerLevel world, BlockPos pos, Fuel fuel, int amount) {
        BiomeId biome = BiomeId.from((LevelAccessor)world, (BlockPos)pos);
        for (Pollutant<?> pollutant : fuel.getPollutants()) {
            BlockEntity tile;
            if (!pollutant.inAllowableDimension(world)) continue;
            float biomeRate = pollutant.getEmissionRateIn(biome);
            float emitterRate = emitter.getEmissionOf(pollutant);
            double totalAmount = (float)amount * fuel.getEmissionOf(pollutant) * biomeRate * emitterRate * Emission.globalRate;
            int intAmount = this.getIntAndUpdateFractAmount(pollutant, totalAmount);
            if (intAmount <= 0) continue;
            if (type.isTile() && (tile = world.m_7702_(pos)) != null) {
                WorldData.scheduleEmissionFor(tile, emitter, pollutant, intAmount);
                continue;
            }
            pollutant.generateAt((WorldGenLevel)world, pos, intAmount, 1);
        }
    }

    public void increaseBy(SourceBase source, float factor, ServerLevel world, BlockPos pos) {
        BiomeId biome = BiomeId.from((LevelAccessor)world, (BlockPos)pos);
        for (Pollutant<?> pollutant : source.getPollutants()) {
            BlockEntity tile;
            Emitter emitter;
            if (!pollutant.inAllowableDimension(world)) continue;
            float biomeRate = pollutant.getEmissionRateIn(biome);
            double totalAmount = factor * source.getEmissionOf(pollutant) * biomeRate * Emission.globalRate;
            int intAmount = this.getIntAndUpdateFractAmount(pollutant, totalAmount);
            if (intAmount <= 0) continue;
            if (source instanceof Emitter && (emitter = (Emitter)source).getType().isTile() && (tile = world.m_7702_(pos)) != null) {
                WorldData.scheduleEmissionFor(tile, emitter, pollutant, intAmount);
                continue;
            }
            pollutant.generateAt((WorldGenLevel)world, pos, intAmount, 1);
        }
    }

    protected int getIntAndUpdateFractAmount(Pollutant<?> pollutant, double amount) {
        if (CommonMath.notZero((double)amount)) {
            PollutionInfo info = this.getOrCreateInfoFor(pollutant);
            double fractAmount = info.getFraction() + amount;
            int intAmount = Mth.m_14107_((double)fractAmount);
            info.setFraction(fractAmount -= (double)intAmount);
            return intAmount;
        }
        return 0;
    }

    public void increaseBy(ServerLevel world, BlockPos pos, BlockState state, int blocksAmount) {
        Pollutant pollutant;
        Block block;
        if (state != null && (block = state.m_60734_()) instanceof Pollutant && (pollutant = (Pollutant)block).affectsPollutionLevel((LevelAccessor)world, pos, state)) {
            int amount = pollutant.getCarriedPollutionAmount(state) * blocksAmount;
            this.increaseBy(world, pollutant, amount);
        }
    }

    protected void increaseBy(ServerLevel world, Pollutant<?> pollutant, int amount) {
        if (amount != 0) {
            PollutionInfo info = this.getOrCreateInfoFor(pollutant);
            info.increaseQuantity(amount);
        }
    }

    public ChunkLoc getLocation() {
        return this.location;
    }

    public void clean(ServerLevel level) {
        ChunkBounds bounds = this.getLocation().getBounds((LevelHeightAccessor)level);
        int x = bounds.getX().getMin();
        while (bounds.getX().encloses(Integer.valueOf(x))) {
            int z = bounds.getZ().getMin();
            while (bounds.getZ().encloses(Integer.valueOf(z))) {
                int y = bounds.getY().getMin();
                while (bounds.getY().encloses(Integer.valueOf(y))) {
                    BlockPos pos = new BlockPos(x, y, z);
                    Block block = level.m_8055_(pos).m_60734_();
                    if (block instanceof Pollutant) {
                        level.m_7471_(pos, false);
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        AABB chunkAABB = this.getLocation().getBounds((LevelHeightAccessor)level).toAABB();
        level.m_142425_(EntityTypeTest.m_156916_(GasEntity.class), chunkAABB, gas -> true).forEach(gas -> gas.m_146870_());
        this.getLocation().getChunk((Level)level).ifPresent(chunk -> chunk.m_8092_(true));
        this.infoForPollutant.clear();
    }

    public void recalculate(Level level) {
        this.getInfos().forEach(info -> info.setQuantity(0));
        ChunkBounds bounds = this.getLocation().getBounds((LevelHeightAccessor)level);
        bounds.forEach(pos -> {
            Pollutant pollutant;
            BlockState state = level.m_8055_((BlockPos)pos);
            Block patt8215$temp = state.m_60734_();
            if (patt8215$temp instanceof Pollutant && (pollutant = (Pollutant)patt8215$temp).affectsPollutionLevel((LevelAccessor)level, (BlockPos)pos, state)) {
                int amount = pollutant.getCarriedPollutionAmount(state);
                this.getOrCreateInfoFor(pollutant).increaseQuantity(amount);
            }
        });
        this.getLocation().getChunk(level).ifPresent(chunk -> chunk.m_8092_(true));
    }

    public boolean isUnloaded() {
        return this.unloaded;
    }

    public void setUnloaded(boolean value) {
        this.unloaded = value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Args.group((Object[])new Object[]{this.getInfos(), Args.get((String)"location", (Object)this.getLocation())});
    }

    public static enum Influence {
        ALWAYS,
        CLOUD,
        NEVER;


        public static class Property<K>
        extends MultiConfigProperty.BaseProperty<K, Influence> {
            public static <K> Property<K> create(UnitConfig config, String category, String name, Influence defaultValue, String comment) {
                Property<K> property = new Property<K>(config, category, name, defaultValue, comment);
                property.defaultValue = property.getFrom(config, category, defaultValue);
                return property;
            }

            protected Property(UnitConfig config, String category, String name, Influence defaultValue, String comment) {
                super(config, category, name, (Object)defaultValue, comment);
            }

            public Influence getFrom(UnitConfig config, String category, Influence defaultValue) {
                String name = UnitConfig.getStr((UnitConfig)config, (String)category, (String)this.getName(), (String)defaultValue.name(), (String)this.getComment());
                try {
                    return Influence.valueOf(name.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    AdPother.getInstance().getLogger().error("Failed to get ChunkPollution.Influence value for " + CommonString.doubleQuoted((String)name) + " in " + config.getConfigFile());
                    return defaultValue;
                }
            }
        }
    }
}

