/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.bearing;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SailBlock
extends WrenchableDirectionalBlock {
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());
    protected final boolean frame;
    protected final DyeColor color;

    public static SailBlock frame(BlockBehaviour.Properties properties) {
        return new SailBlock(properties, true, null);
    }

    public static SailBlock withCanvas(BlockBehaviour.Properties properties, DyeColor color) {
        return new SailBlock(properties, false, color);
    }

    protected SailBlock(BlockBehaviour.Properties properties, boolean frame, DyeColor color) {
        super(properties);
        this.frame = frame;
        this.color = color;
    }

    public void m_49811_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.frame || this.color == DyeColor.WHITE) {
            super.m_49811_(tab, items);
        }
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)((Direction)state.m_61143_((Property)f_52588_)).m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack heldItem = player.m_21120_(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (!player.m_6144_() && player.m_36326_() && placementHelper.matchesItem(heldItem)) {
            placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_41720_() instanceof ShearsItem) {
            if (!world.f_46443_) {
                world.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.applyDye(state, world, pos, ray.m_82450_(), null);
            return InteractionResult.SUCCESS;
        }
        if (this.frame) {
            return InteractionResult.PASS;
        }
        DyeColor color = DyeColor.getColor((ItemStack)heldItem);
        if (color != null) {
            if (!world.f_46443_) {
                world.m_5594_(null, pos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.1f - world.f_46441_.nextFloat() * 0.2f);
            }
            this.applyDye(state, world, pos, ray.m_82450_(), color);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void applyDye(BlockState state, Level world, BlockPos pos, Vec3 hit, @Nullable DyeColor color) {
        BlockState newState = (color == null ? AllBlocks.SAIL_FRAME : AllBlocks.DYED_SAILS.get(color)).getDefaultState();
        if (state != (newState = BlockHelper.copyProperties(state, newState))) {
            world.m_46597_(pos, newState);
            return;
        }
        List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, hit, ((Direction)state.m_61143_((Property)f_52588_)).m_122434_());
        for (Direction d : directions) {
            BlockPos offset = pos.m_142300_(d);
            BlockState adjacentState = world.m_8055_(offset);
            Block block = adjacentState.m_60734_();
            if (!(block instanceof SailBlock) || ((SailBlock)block).frame || state.m_61143_((Property)f_52588_) != adjacentState.m_61143_((Property)f_52588_) || state == adjacentState) continue;
            world.m_46597_(offset, newState);
            return;
        }
        ArrayList<BlockPos> frontier = new ArrayList<BlockPos>();
        frontier.add(pos);
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        int timeout = 100;
        while (!frontier.isEmpty() && timeout-- >= 0) {
            BlockPos currentPos = (BlockPos)frontier.remove(0);
            visited.add(currentPos);
            for (Direction d : Iterate.directions) {
                BlockState adjacentState;
                Block block;
                BlockPos offset;
                if (d.m_122434_() == ((Direction)state.m_61143_((Property)f_52588_)).m_122434_() || visited.contains(offset = currentPos.m_142300_(d)) || !((block = (adjacentState = world.m_8055_(offset)).m_60734_()) instanceof SailBlock) || ((SailBlock)block).frame && color != null || adjacentState.m_61143_((Property)f_52588_) != state.m_61143_((Property)f_52588_)) continue;
                if (state != adjacentState) {
                    world.m_46597_(offset, newState);
                }
                frontier.add(offset);
                visited.add(offset);
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return (this.frame ? AllShapes.SAIL_FRAME : AllShapes.SAIL).get((Direction)state.m_61143_((Property)f_52588_));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        if (this.frame) {
            return AllShapes.SAIL_FRAME_COLLISION.get((Direction)state.m_61143_((Property)f_52588_));
        }
        return this.m_5940_(state, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack pickBlock = super.getCloneItemStack(state, target, world, pos, player);
        if (pickBlock.m_41619_()) {
            return ((SailBlock)AllBlocks.SAIL.get()).getCloneItemStack(state, target, world, pos, player);
        }
        return pickBlock;
    }

    public void m_142072_(Level p_152426_, BlockState p_152427_, BlockPos p_152428_, Entity p_152429_, float p_152430_) {
        if (this.frame) {
            super.m_142072_(p_152426_, p_152427_, p_152428_, p_152429_, p_152430_);
        }
        super.m_142072_(p_152426_, p_152427_, p_152428_, p_152429_, 0.0f);
    }

    public void m_5548_(BlockGetter p_176216_1_, Entity p_176216_2_) {
        if (this.frame || p_176216_2_.m_20162_()) {
            super.m_5548_(p_176216_1_, p_176216_2_);
        } else {
            this.bounce(p_176216_2_);
        }
    }

    private void bounce(Entity p_226860_1_) {
        Vec3 Vector3d = p_226860_1_.m_20184_();
        if (Vector3d.f_82480_ < 0.0) {
            double d0 = p_226860_1_ instanceof LivingEntity ? 1.0 : 0.8;
            p_226860_1_.m_20334_(Vector3d.f_82479_, -Vector3d.f_82480_ * (double)0.26f * d0, Vector3d.f_82481_);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public boolean isFrame() {
        return this.frame;
    }

    public DyeColor getColor() {
        return this.color;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return i -> AllBlocks.SAIL.isIn(i) || AllBlocks.SAIL_FRAME.isIn(i);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return s -> s.m_60734_() instanceof SailBlock;
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List<Direction> directions = IPlacementHelper.orderedByDistanceExceptAxis(pos, ray.m_82450_(), ((Direction)state.m_61143_((Property)f_52588_)).m_122434_(), (Direction dir) -> world.m_8055_(pos.m_142300_(dir)).m_60767_().m_76336_());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.m_142300_(directions.get(0)), s -> (BlockState)s.m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)((Direction)state.m_61143_((Property)DirectionalBlock.f_52588_))));
        }
    }
}

