/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.glue;

import com.google.common.base.Objects;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.glue.SuperGlueItem;
import com.simibubi.create.content.contraptions.glue.SuperGlueRemovalPacket;
import com.simibubi.create.content.contraptions.glue.SuperGlueSelectionHelper;
import com.simibubi.create.content.contraptions.glue.SuperGlueSelectionPacket;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.RaycastHelper;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class SuperGlueSelectionHandler {
    private static final int PASSIVE = 5083490;
    private static final int HIGHLIGHT = 6866310;
    private static final int FAIL = 12957000;
    private Object clusterOutlineSlot = new Object();
    private Object bbOutlineSlot = new Object();
    private int clusterCooldown;
    private BlockPos firstPos;
    private BlockPos hoveredPos;
    private Set<BlockPos> currentCluster;
    private int glueRequired;
    private SuperGlueEntity selected;
    private BlockPos soundSourceForRemoval;

    public void tick() {
        HitResult hitResult;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        BlockPos hovered = null;
        ItemStack stack = player.m_21205_();
        if (!this.isGlue(stack)) {
            if (this.firstPos != null) {
                this.discard();
            }
            return;
        }
        if (this.clusterCooldown > 0) {
            if (this.clusterCooldown == 25) {
                player.m_5661_(Components.immutableEmpty(), true);
            }
            CreateClient.OUTLINER.keep(this.clusterOutlineSlot);
            --this.clusterCooldown;
        }
        AABB scanArea = player.m_142469_().m_82377_(32.0, 16.0, 32.0);
        List glueNearby = mc.f_91073_.m_45976_(SuperGlueEntity.class, scanArea);
        this.selected = null;
        if (this.firstPos == null) {
            double range = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_() + 1.0;
            Vec3 traceOrigin = RaycastHelper.getTraceOrigin((Player)player);
            Vec3 traceTarget = RaycastHelper.getTraceTarget((Player)player, range, traceOrigin);
            double bestDistance = Double.MAX_VALUE;
            for (SuperGlueEntity glueEntity : glueNearby) {
                Vec3 vec3;
                double distanceToSqr;
                Optional clip = glueEntity.m_142469_().m_82371_(traceOrigin, traceTarget);
                if (clip.isEmpty() || (distanceToSqr = (vec3 = (Vec3)clip.get()).m_82557_(traceOrigin)) > bestDistance) continue;
                this.selected = glueEntity;
                this.soundSourceForRemoval = new BlockPos(vec3);
                bestDistance = distanceToSqr;
            }
            for (SuperGlueEntity glueEntity : glueNearby) {
                boolean h = this.clusterCooldown == 0 && glueEntity == this.selected;
                AllSpecialTextures faceTex = h ? AllSpecialTextures.GLUE : null;
                CreateClient.OUTLINER.showAABB(glueEntity, glueEntity.m_142469_()).colored(h ? 6866310 : 5083490).withFaceTextures(faceTex, faceTex).disableLineNormals().lineWidth(h ? 0.0625f : 0.015625f);
            }
        }
        if ((hitResult = mc.f_91077_) != null && hitResult.m_6662_() == HitResult.Type.BLOCK) {
            hovered = ((BlockHitResult)hitResult).m_82425_();
        }
        if (hovered == null) {
            this.hoveredPos = null;
            return;
        }
        if (this.firstPos != null && !this.firstPos.m_123314_((Vec3i)hovered, 24.0)) {
            Lang.translate("super_glue.too_far", new Object[0]).color(12957000).sendStatus((Player)player);
            return;
        }
        boolean cancel = player.m_20161_();
        if (cancel && this.firstPos == null) {
            return;
        }
        AABB currentSelectionBox = this.getCurrentSelectionBox();
        boolean unchanged = Objects.equal((Object)hovered, (Object)this.hoveredPos);
        if (unchanged) {
            if (this.currentCluster != null) {
                boolean canReach = this.currentCluster.contains(hovered);
                boolean canAfford = SuperGlueSelectionHelper.collectGlueFromInventory((Player)player, this.glueRequired, true);
                int color = 6866310;
                String key = "super_glue.click_to_confirm";
                if (!canReach) {
                    color = 12957000;
                    key = "super_glue.cannot_reach";
                } else if (!canAfford) {
                    color = 12957000;
                    key = "super_glue.not_enough";
                } else if (cancel) {
                    color = 12957000;
                    key = "super_glue.click_to_discard";
                }
                Lang.translate(key, new Object[0]).color(color).sendStatus((Player)player);
                if (currentSelectionBox != null) {
                    CreateClient.OUTLINER.showAABB(this.bbOutlineSlot, currentSelectionBox).colored(canReach && canAfford && !cancel ? 6866310 : 12957000).withFaceTextures(AllSpecialTextures.GLUE, AllSpecialTextures.GLUE).disableLineNormals().lineWidth(0.0625f);
                }
                CreateClient.OUTLINER.showCluster(this.clusterOutlineSlot, this.currentCluster).colored(5083490).disableLineNormals().lineWidth(0.015625f);
            }
            return;
        }
        this.hoveredPos = hovered;
        Set<BlockPos> cluster = SuperGlueSelectionHelper.searchGlueGroup((Level)mc.f_91073_, this.firstPos, this.hoveredPos, true);
        this.currentCluster = cluster;
        this.glueRequired = 1;
    }

    private boolean isGlue(ItemStack stack) {
        return stack.m_41720_() instanceof SuperGlueItem;
    }

    private AABB getCurrentSelectionBox() {
        return this.firstPos == null || this.hoveredPos == null ? null : new AABB(this.firstPos, this.hoveredPos).m_82363_(1.0, 1.0, 1.0);
    }

    public boolean onMouseInput(boolean attack) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (!this.isGlue(player.m_21205_())) {
            return false;
        }
        if (attack) {
            if (this.selected == null) {
                return false;
            }
            AllPackets.getChannel().sendToServer((Object)new SuperGlueRemovalPacket(this.selected.m_142049_(), this.soundSourceForRemoval));
            this.selected = null;
            this.clusterCooldown = 0;
            return true;
        }
        if (player.m_20161_()) {
            if (this.firstPos != null) {
                this.discard();
                return true;
            }
            return false;
        }
        if (this.hoveredPos == null) {
            return false;
        }
        Direction face = null;
        HitResult hitResult = mc.f_91077_;
        if (hitResult instanceof BlockHitResult) {
            AbstractChassisBlock cb;
            BlockHitResult bhr = (BlockHitResult)hitResult;
            face = bhr.m_82434_();
            BlockState blockState = level.m_8055_(this.hoveredPos);
            Block block = blockState.m_60734_();
            if (block instanceof AbstractChassisBlock && (cb = (AbstractChassisBlock)block).getGlueableSide(blockState, bhr.m_82434_()) != null) {
                return false;
            }
        }
        if (this.firstPos != null && this.currentCluster != null) {
            boolean canReach = this.currentCluster.contains(this.hoveredPos);
            boolean canAfford = SuperGlueSelectionHelper.collectGlueFromInventory((Player)player, this.glueRequired, true);
            if (!canReach || !canAfford) {
                return true;
            }
            this.confirm();
            return true;
        }
        this.firstPos = this.hoveredPos;
        if (face != null) {
            SuperGlueItem.spawnParticles((Level)level, this.firstPos, face, true);
        }
        Lang.translate("super_glue.first_pos", new Object[0]).sendStatus((Player)player);
        AllSoundEvents.SLIME_ADDED.playAt((Level)level, (Vec3i)this.firstPos, 0.5f, 0.85f, false);
        level.m_5594_((Player)player, this.firstPos, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.75f, 1.0f);
        return true;
    }

    public void discard() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        this.currentCluster = null;
        this.firstPos = null;
        Lang.translate("super_glue.abort", new Object[0]).sendStatus((Player)player);
        this.clusterCooldown = 0;
    }

    public void confirm() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        AllPackets.getChannel().sendToServer((Object)new SuperGlueSelectionPacket(this.firstPos, this.hoveredPos));
        AllSoundEvents.SLIME_ADDED.playAt(player.f_19853_, (Vec3i)this.hoveredPos, 0.5f, 0.95f, false);
        player.f_19853_.m_5594_((Player)player, this.hoveredPos, SoundEvents.f_12013_, SoundSource.BLOCKS, 0.75f, 1.0f);
        if (this.currentCluster != null) {
            CreateClient.OUTLINER.showCluster(this.clusterOutlineSlot, this.currentCluster).colored(11924166).withFaceTextures(AllSpecialTextures.GLUE, AllSpecialTextures.HIGHLIGHT_CHECKERED).disableLineNormals().lineWidth(0.041666668f);
        }
        this.discard();
        Lang.translate("super_glue.success", new Object[0]).sendStatus((Player)player);
        this.clusterCooldown = 40;
    }
}

