/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.glue;

import com.simibubi.create.content.contraptions.BlockMovementChecks;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import com.simibubi.create.content.contraptions.glue.SuperGlueItem;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SuperGlueSelectionHelper {
    public static Set<BlockPos> searchGlueGroup(Level level, BlockPos startPos, BlockPos endPos, boolean includeOther) {
        if (endPos == null || startPos == null) {
            return null;
        }
        AABB bb = SuperGlueEntity.span(startPos, endPos);
        ArrayList<BlockPos> frontier = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        HashSet<BlockPos> attached = new HashSet<BlockPos>();
        HashSet<SuperGlueEntity> cachedOther = new HashSet<SuperGlueEntity>();
        visited.add(startPos);
        frontier.add(startPos);
        while (!frontier.isEmpty()) {
            BlockPos currentPos = (BlockPos)frontier.remove(0);
            attached.add(currentPos);
            for (Direction d : Iterate.directions) {
                boolean alreadySticky;
                BlockPos offset = currentPos.m_142300_(d);
                boolean gluePresent = includeOther && SuperGlueEntity.isGlued((LevelAccessor)level, currentPos, d, cachedOther);
                boolean bl = alreadySticky = includeOther && SuperGlueEntity.isSideSticky(level, currentPos, d) || SuperGlueEntity.isSideSticky(level, offset, d.m_122424_());
                if (!alreadySticky && !gluePresent && !bb.m_82390_(Vec3.m_82512_((Vec3i)offset)) || !BlockMovementChecks.isMovementNecessary(level.m_8055_(offset), level, offset) || !SuperGlueEntity.isValidFace(level, currentPos, d) || !SuperGlueEntity.isValidFace(level, offset, d.m_122424_()) || !visited.add(offset)) continue;
                frontier.add(offset);
            }
        }
        if (attached.size() < 2 && attached.contains(endPos)) {
            return null;
        }
        return attached;
    }

    public static boolean collectGlueFromInventory(Player player, int requiredAmount, boolean simulate) {
        if (player.m_150110_().f_35937_) {
            return true;
        }
        if (requiredAmount == 0) {
            return true;
        }
        NonNullList items = player.m_150109_().f_35974_;
        for (int i = -1; i < items.size(); ++i) {
            int slot = i == -1 ? player.m_150109_().f_35977_ : i;
            ItemStack stack = (ItemStack)items.get(slot);
            if (stack.m_41619_() || !stack.m_41763_() || !(stack.m_41720_() instanceof SuperGlueItem)) continue;
            int charges = Math.min(requiredAmount, stack.m_41776_() - stack.m_41773_());
            if (!simulate) {
                stack.m_41622_(charges, (LivingEntity)player, i == -1 ? SuperGlueItem::onBroken : $ -> {});
            }
            if ((requiredAmount -= charges) > 0) continue;
            return true;
        }
        return false;
    }
}

