/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration;

import com.simibubi.create.content.equipment.extendoGrip.ExtendoGripItem;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public class MetalLadderBlock
extends LadderBlock
implements IWrenchable {
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public MetalLadderBlock(BlockBehaviour.Properties p_54345_) {
        super(p_54345_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean supportsExternalFaceHiding(BlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState pState, BlockState pAdjacentBlockState, Direction pDirection) {
        return pDirection == Direction.UP && pAdjacentBlockState.m_60734_() instanceof LadderBlock;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (player.m_6144_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        IPlacementHelper helper = PlacementHelpers.get(placementHelperId);
        if (helper.matchesItem(heldItem)) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
        }
        return InteractionResult.PASS;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.m_41720_() instanceof BlockItem && ((BlockItem)i.m_41720_()).m_40614_() instanceof MetalLadderBlock;
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return s -> s.m_60734_() instanceof LadderBlock;
        }

        public int attachedLadders(Level world, BlockPos pos, Direction direction) {
            BlockPos checkPos = pos.m_142300_(direction);
            BlockState state = world.m_8055_(checkPos);
            int count = 0;
            while (this.getStatePredicate().test(state)) {
                ++count;
                checkPos = checkPos.m_142300_(direction);
                state = world.m_8055_(checkPos);
            }
            return count;
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            int ladders;
            AttributeInstance reach;
            Direction dir = player.m_146909_() < 0.0f ? Direction.UP : Direction.DOWN;
            int range = (Integer)AllConfigs.server().equipment.placementAssistRange.get();
            if (player != null && (reach = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get())) != null && reach.m_22109_(ExtendoGripItem.singleRangeAttributeModifier)) {
                range += 4;
            }
            if ((ladders = this.attachedLadders(world, pos, dir)) >= range) {
                return PlacementOffset.fail();
            }
            BlockPos newPos = pos.m_5484_(dir, ladders + 1);
            BlockState newState = world.m_8055_(newPos);
            if (!state.m_60710_((LevelReader)world, newPos)) {
                return PlacementOffset.fail();
            }
            if (newState.m_60767_().m_76336_()) {
                return PlacementOffset.success((Vec3i)newPos, bState -> (BlockState)bState.m_61124_((Property)LadderBlock.f_54337_, (Comparable)((Direction)state.m_61143_((Property)LadderBlock.f_54337_))));
            }
            return PlacementOffset.fail();
        }
    }
}

