/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.copycat;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.foundation.model.BakedModelWrapperWithData;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public abstract class CopycatModel
extends BakedModelWrapperWithData {
    public static final ModelProperty<BlockState> MATERIAL_PROPERTY = new ModelProperty();
    private static final ModelProperty<OcclusionData> OCCLUSION_PROPERTY = new ModelProperty();
    private static final ModelProperty<IModelData> WRAPPED_DATA_PROPERTY = new ModelProperty();

    public CopycatModel(BakedModel originalModel) {
        super(originalModel);
    }

    @Override
    protected void gatherModelData(ModelDataMap.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, IModelData blockEntityData) {
        BlockState material = CopycatModel.getMaterial(blockEntityData);
        if (material == null) {
            return;
        }
        builder.withInitial(MATERIAL_PROPERTY, (Object)material);
        OcclusionData occlusionData = new OcclusionData();
        Block block = state.m_60734_();
        if (block instanceof CopycatBlock) {
            CopycatBlock copycatBlock = (CopycatBlock)block;
            this.gatherOcclusionData(world, pos, state, material, occlusionData, copycatBlock);
            builder.withInitial(OCCLUSION_PROPERTY, (Object)occlusionData);
        }
        IModelData wrappedData = CopycatModel.getModelOf(material).getModelData(world, pos, material, (IModelData)EmptyModelData.INSTANCE);
        builder.withInitial(WRAPPED_DATA_PROPERTY, (Object)wrappedData);
    }

    private void gatherOcclusionData(BlockAndTintGetter world, BlockPos pos, BlockState state, BlockState material, OcclusionData occlusionData, CopycatBlock copycatBlock) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction face : Iterate.directions) {
            BlockPos.MutableBlockPos neighbourPos = mutablePos.m_122159_((Vec3i)pos, face);
            BlockState neighbourState = world.m_8055_((BlockPos)neighbourPos);
            if (state.supportsExternalFaceHiding() && neighbourState.hidesNeighborFace((BlockGetter)world, (BlockPos)neighbourPos, state, face.m_122424_())) {
                occlusionData.occlude(face);
                continue;
            }
            if (!copycatBlock.canFaceBeOccluded(state, face) || Block.m_152444_((BlockState)material, (BlockGetter)world, (BlockPos)pos, (Direction)face, (BlockPos)neighbourPos)) continue;
            occlusionData.occlude(face);
        }
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData data) {
        Direction[] directionArray;
        CopycatBlock ccb;
        Block block;
        if (side != null && (block = state.m_60734_()) instanceof CopycatBlock && (ccb = (CopycatBlock)block).shouldFaceAlwaysRender(state, side)) {
            return Collections.emptyList();
        }
        BlockState material = CopycatModel.getMaterial(data);
        if (material == null) {
            return super.getQuads(state, side, rand, data);
        }
        OcclusionData occlusionData = (OcclusionData)data.getData(OCCLUSION_PROPERTY);
        if (occlusionData != null && occlusionData.isOccluded(side)) {
            return super.getQuads(state, side, rand, data);
        }
        RenderType renderType = MinecraftForgeClient.getRenderType();
        if (renderType != null && !ItemBlockRenderTypes.canRenderInLayer((BlockState)material, (RenderType)renderType)) {
            return super.getQuads(state, side, rand, data);
        }
        IModelData wrappedData = (IModelData)data.getData(WRAPPED_DATA_PROPERTY);
        if (wrappedData == null) {
            wrappedData = EmptyModelData.INSTANCE;
        }
        List<BakedQuad> croppedQuads = this.getCroppedQuads(state, side, rand, material, wrappedData);
        if (side == null && (directionArray = state.m_60734_()) instanceof CopycatBlock) {
            CopycatBlock ccb2 = (CopycatBlock)directionArray;
            for (Direction nonOcclusionSide : Iterate.directions) {
                if (!ccb2.shouldFaceAlwaysRender(state, nonOcclusionSide)) continue;
                croppedQuads.addAll(this.getCroppedQuads(state, nonOcclusionSide, rand, material, wrappedData));
            }
        }
        return croppedQuads;
    }

    protected abstract List<BakedQuad> getCroppedQuads(BlockState var1, Direction var2, Random var3, BlockState var4, IModelData var5);

    public TextureAtlasSprite getParticleIcon(IModelData data) {
        BlockState material = CopycatModel.getMaterial(data);
        if (material == null) {
            return super.getParticleIcon(data);
        }
        IModelData wrappedData = (IModelData)data.getData(WRAPPED_DATA_PROPERTY);
        if (wrappedData == null) {
            wrappedData = EmptyModelData.INSTANCE;
        }
        return CopycatModel.getModelOf(material).getParticleIcon(wrappedData);
    }

    @Nullable
    public static BlockState getMaterial(IModelData data) {
        BlockState material = (BlockState)data.getData(MATERIAL_PROPERTY);
        return material == null ? AllBlocks.COPYCAT_BASE.getDefaultState() : material;
    }

    public static BakedModel getModelOf(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110910_(state);
    }

    private static class OcclusionData {
        private final boolean[] occluded = new boolean[6];

        public void occlude(Direction face) {
            this.occluded[face.m_122411_()] = true;
        }

        public boolean isOccluded(Direction face) {
            return face == null ? false : this.occluded[face.m_122411_()];
        }
    }
}

