/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.armor;

import com.simibubi.create.content.equipment.armor.BaseArmorItem;
import com.simibubi.create.foundation.utility.NBTHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DivingBootsItem
extends BaseArmorItem {
    public static final EquipmentSlot SLOT = EquipmentSlot.FEET;

    public DivingBootsItem(ArmorMaterial material, Item.Properties properties, ResourceLocation textureLoc) {
        super(material, SLOT, properties, textureLoc);
    }

    public static boolean isWornBy(Entity entity) {
        return !DivingBootsItem.getWornItem(entity).m_41619_();
    }

    public static ItemStack getWornItem(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return ItemStack.f_41583_;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ItemStack stack = livingEntity.m_6844_(SLOT);
        if (!(stack.m_41720_() instanceof DivingBootsItem)) {
            return ItemStack.f_41583_;
        }
        return stack;
    }

    @SubscribeEvent
    public static void accellerateDescentUnderwater(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!DivingBootsItem.affects(entity)) {
            return;
        }
        Vec3 motion = entity.m_20184_();
        boolean isJumping = entity.f_20899_;
        entity.m_6853_(entity.m_20096_() || entity.f_19863_);
        if (isJumping && entity.m_20096_()) {
            motion = motion.m_82520_(0.0, 0.5, 0.0);
            entity.m_6853_(false);
        } else {
            motion = motion.m_82520_(0.0, (double)-0.05f, 0.0);
        }
        float multiplier = 1.3f;
        if (motion.m_82542_(1.0, 0.0, 1.0).m_82553_() < (double)0.145f && (entity.f_20902_ > 0.0f || entity.f_20900_ != 0.0f) && !entity.m_6144_()) {
            motion = motion.m_82542_((double)multiplier, 1.0, (double)multiplier);
        }
        entity.m_20256_(motion);
    }

    protected static boolean affects(LivingEntity entity) {
        if (!DivingBootsItem.isWornBy((Entity)entity)) {
            entity.getPersistentData().m_128473_("HeavyBoots");
            return false;
        }
        NBTHelper.putMarker(entity.getPersistentData(), "HeavyBoots");
        if (!entity.m_20069_()) {
            return false;
        }
        if (entity.m_20089_() == Pose.SWIMMING) {
            return false;
        }
        if (entity instanceof Player) {
            Player playerEntity = (Player)entity;
            if (playerEntity.m_150110_().f_35935_) {
                return false;
            }
        }
        return true;
    }

    public static Vec3 getMovementMultiplier(LivingEntity entity) {
        double vMultiplier;
        double yMotion = entity.m_20184_().f_82480_;
        double d = vMultiplier = yMotion < 0.0 ? Math.max(0.0, 2.5 - Math.abs(yMotion) * 2.0) : 1.0;
        if (!entity.m_20096_()) {
            if (entity.f_20899_ && entity.getPersistentData().m_128441_("LavaGrounded")) {
                boolean eyeInFluid = entity.m_204029_(FluidTags.f_13132_);
                vMultiplier = yMotion == 0.0 ? 0.0 : (eyeInFluid ? 1.0 : 0.5) / yMotion;
            } else if (yMotion > 0.0) {
                vMultiplier = 1.3;
            }
            entity.getPersistentData().m_128473_("LavaGrounded");
            return new Vec3(1.75, vMultiplier, 1.75);
        }
        entity.getPersistentData().m_128379_("LavaGrounded", true);
        double hMultiplier = entity.m_20142_() ? 1.85 : 1.75;
        return new Vec3(hMultiplier, vMultiplier, hMultiplier);
    }
}

