/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.transfer;

import com.simibubi.create.AllFluids;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.foundation.fluid.FluidHelper;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class GenericItemFilling {
    public static boolean isFluidHandlerValid(ItemStack stack, IFluidHandlerItem fluidHandler) {
        Item item;
        return fluidHandler.getClass() != FluidBucketWrapper.class || (item = stack.m_41720_()).getClass() == BucketItem.class || item instanceof MilkBucketItem;
    }

    public static boolean canItemBeFilled(Level world, ItemStack stack) {
        if (stack.m_41720_() == Items.f_42590_) {
            return true;
        }
        if (stack.m_41720_() == Items.f_42455_) {
            return false;
        }
        LazyOptional capability = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        IFluidHandlerItem tank = (IFluidHandlerItem)capability.orElse(null);
        if (tank == null) {
            return false;
        }
        if (!GenericItemFilling.isFluidHandlerValid(stack, tank)) {
            return false;
        }
        for (int i = 0; i < tank.getTanks(); ++i) {
            if (tank.getFluidInTank(i).getAmount() >= tank.getTankCapacity(i)) continue;
            return true;
        }
        return false;
    }

    public static int getRequiredAmountForItem(Level world, ItemStack stack, FluidStack availableFluid) {
        if (stack.m_41720_() == Items.f_42590_ && GenericItemFilling.canFillGlassBottleInternally(availableFluid)) {
            return PotionFluidHandler.getRequiredAmountForFilledBottle(stack, availableFluid);
        }
        if (stack.m_41720_() == Items.f_42446_ && GenericItemFilling.canFillBucketInternally(availableFluid)) {
            return 1000;
        }
        LazyOptional capability = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        IFluidHandlerItem tank = (IFluidHandlerItem)capability.orElse(null);
        if (tank == null) {
            return -1;
        }
        if (tank instanceof FluidBucketWrapper) {
            Item filledBucket = availableFluid.getFluid().m_6859_();
            if (filledBucket == null || filledBucket == Items.f_41852_) {
                return -1;
            }
            if (!((FluidBucketWrapper)tank).getFluid().isEmpty()) {
                return -1;
            }
            return 1000;
        }
        int filled = tank.fill(availableFluid, IFluidHandler.FluidAction.SIMULATE);
        return filled == 0 ? -1 : filled;
    }

    private static boolean canFillGlassBottleInternally(FluidStack availableFluid) {
        Fluid fluid = availableFluid.getFluid();
        if (fluid.m_6212_((Fluid)Fluids.f_76193_)) {
            return true;
        }
        if (fluid.m_6212_((Fluid)AllFluids.POTION.get())) {
            return true;
        }
        return fluid.m_6212_((Fluid)AllFluids.TEA.get());
    }

    private static boolean canFillBucketInternally(FluidStack availableFluid) {
        return false;
    }

    public static ItemStack fillItem(Level world, int requiredAmount, ItemStack stack, FluidStack availableFluid) {
        FluidStack toFill = availableFluid.copy();
        toFill.setAmount(requiredAmount);
        availableFluid.shrink(requiredAmount);
        if (stack.m_41720_() == Items.f_42590_ && GenericItemFilling.canFillGlassBottleInternally(toFill)) {
            ItemStack fillBottle = ItemStack.f_41583_;
            Fluid fluid = toFill.getFluid();
            fillBottle = FluidHelper.isWater(fluid) ? PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_) : (fluid.m_6212_((Fluid)AllFluids.TEA.get()) ? AllItems.BUILDERS_TEA.asStack() : PotionFluidHandler.fillBottle(stack, toFill));
            stack.m_41774_(1);
            return fillBottle;
        }
        ItemStack split = stack.m_41777_();
        split.m_41764_(1);
        LazyOptional capability = split.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        IFluidHandlerItem tank = (IFluidHandlerItem)capability.orElse(null);
        if (tank == null) {
            return ItemStack.f_41583_;
        }
        tank.fill(toFill, IFluidHandler.FluidAction.EXECUTE);
        ItemStack container = tank.getContainer().m_41777_();
        stack.m_41774_(1);
        return container;
    }
}

