/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.belt.transport;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltPart;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BeltMovementHandler {
    public static boolean canBeTransported(Entity entity) {
        if (!entity.m_6084_()) {
            return false;
        }
        return !(entity instanceof Player) || !((Player)entity).m_6144_();
    }

    public static void transportEntity(BeltBlockEntity beltBE, Entity entityIn, TransportedEntityInfo info) {
        boolean movedPastEndingSlope;
        boolean movingUp;
        boolean movingDown;
        boolean onSlope;
        double diffCenter;
        boolean notHorizontal;
        boolean betweenBelts;
        BlockPos pos = info.lastCollidedPos;
        Level world = beltBE.m_58904_();
        BlockEntity be = world.m_7702_(pos);
        BlockEntity blockEntityBelowPassenger = world.m_7702_(entityIn.m_142538_());
        BlockState blockState = info.lastCollidedState;
        Direction movementFacing = Direction.m_122387_((Direction.Axis)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_(), (Direction.AxisDirection)(beltBE.getSpeed() < 0.0f ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
        boolean collidedWithBelt = be instanceof BeltBlockEntity;
        boolean bl = betweenBelts = blockEntityBelowPassenger instanceof BeltBlockEntity && blockEntityBelowPassenger != be;
        if (!collidedWithBelt || betweenBelts) {
            return;
        }
        boolean bl2 = notHorizontal = beltBE.m_58900_().m_61143_(BeltBlock.SLOPE) != BeltSlope.HORIZONTAL;
        if (Math.abs(beltBE.getSpeed()) < 1.0f) {
            return;
        }
        if (entityIn.m_20186_() - 0.25 < (double)pos.m_123342_()) {
            return;
        }
        boolean isPlayer = entityIn instanceof Player;
        if (entityIn instanceof LivingEntity && !isPlayer) {
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 1, false, false));
        }
        Direction beltFacing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        BeltSlope slope = (BeltSlope)((Object)blockState.m_61143_(BeltBlock.SLOPE));
        Direction.Axis axis = beltFacing.m_122434_();
        float movementSpeed = beltBE.getBeltMovementSpeed();
        Direction movementDirection = Direction.m_122390_((Direction.AxisDirection)(axis == Direction.Axis.X ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)axis);
        Vec3i centeringDirection = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)beltFacing.m_122427_().m_122434_()).m_122436_();
        Vec3 movement = Vec3.m_82528_((Vec3i)movementDirection.m_122436_()).m_82490_((double)movementSpeed);
        double d = diffCenter = axis == Direction.Axis.Z ? (double)((float)pos.m_123341_() + 0.5f) - entityIn.m_20185_() : (double)((float)pos.m_123343_() + 0.5f) - entityIn.m_20189_();
        if (Math.abs(diffCenter) > 0.75) {
            return;
        }
        BeltPart part = (BeltPart)((Object)blockState.m_61143_(BeltBlock.PART));
        float top = 0.8125f;
        boolean bl3 = notHorizontal && (part == BeltPart.MIDDLE || part == BeltPart.PULLEY || part == (slope == BeltSlope.UPWARD ? BeltPart.END : BeltPart.START) && entityIn.m_20186_() - (double)pos.m_123342_() < (double)top || part == (slope == BeltSlope.UPWARD ? BeltPart.START : BeltPart.END) && entityIn.m_20186_() - (double)pos.m_123342_() > (double)top) ? true : (onSlope = false);
        boolean bl4 = onSlope && slope == (movementFacing == beltFacing ? BeltSlope.DOWNWARD : BeltSlope.UPWARD) ? true : (movingDown = false);
        boolean bl5 = onSlope && slope == (movementFacing == beltFacing ? BeltSlope.UPWARD : BeltSlope.DOWNWARD) ? true : (movingUp = false);
        if (beltFacing.m_122434_() == Direction.Axis.Z) {
            boolean b = movingDown;
            movingDown = movingUp;
            movingUp = b;
        }
        if (movingUp) {
            movement = movement.m_82520_(0.0, Math.abs(axis.m_6150_(movement.f_82479_, movement.f_82480_, movement.f_82481_)), 0.0);
        }
        if (movingDown) {
            movement = movement.m_82520_(0.0, -Math.abs(axis.m_6150_(movement.f_82479_, movement.f_82480_, movement.f_82481_)), 0.0);
        }
        Vec3 centering = Vec3.m_82528_((Vec3i)centeringDirection).m_82490_(diffCenter * (double)Math.min(Math.abs(movementSpeed), 0.1f) * 4.0);
        if (!(entityIn instanceof LivingEntity) || ((LivingEntity)entityIn).f_20902_ == 0.0f && ((LivingEntity)entityIn).f_20900_ == 0.0f) {
            movement = movement.m_82549_(centering);
        }
        float step = entityIn.f_19793_;
        if (!isPlayer) {
            entityIn.f_19793_ = 1.0f;
        }
        if (Math.abs(movementSpeed) < 0.5f) {
            Vec3 checkDistance = movement.m_82541_().m_82490_(0.5);
            AABB bb = entityIn.m_142469_();
            AABB checkBB = new AABB(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_);
            checkBB = checkBB.m_82383_(checkDistance).m_82377_(-Math.abs(checkDistance.f_82479_), -Math.abs(checkDistance.f_82480_), -Math.abs(checkDistance.f_82481_));
            List list = world.m_45933_(entityIn, checkBB);
            list.removeIf(e -> BeltMovementHandler.shouldIgnoreBlocking(entityIn, e));
            if (!list.isEmpty()) {
                entityIn.m_20334_(0.0, 0.0, 0.0);
                --info.ticksSinceLastCollision;
                return;
            }
        }
        entityIn.f_19789_ = 0.0f;
        if (movingUp) {
            float minVelocity = 0.13f;
            float yMovement = (float)(-Math.max(Math.abs(movement.f_82480_), (double)minVelocity));
            entityIn.m_6478_(MoverType.SELF, new Vec3(0.0, (double)yMovement, 0.0));
            entityIn.m_6478_(MoverType.SELF, movement.m_82542_(1.0, 0.0, 1.0));
        } else if (movingDown) {
            entityIn.m_6478_(MoverType.SELF, movement.m_82542_(1.0, 0.0, 1.0));
            entityIn.m_6478_(MoverType.SELF, movement.m_82542_(0.0, 1.0, 0.0));
        } else {
            entityIn.m_6478_(MoverType.SELF, movement);
        }
        entityIn.m_6853_(true);
        if (!isPlayer) {
            entityIn.f_19793_ = step;
        }
        boolean bl6 = movedPastEndingSlope = onSlope && (AllBlocks.BELT.has(world.m_8055_(entityIn.m_142538_())) || AllBlocks.BELT.has(world.m_8055_(entityIn.m_142538_().m_7495_())));
        if (movedPastEndingSlope && !movingDown && Math.abs(movementSpeed) > 0.0f) {
            entityIn.m_6034_(entityIn.m_20185_(), entityIn.m_20186_() + movement.f_82480_, entityIn.m_20189_());
        }
        if (movedPastEndingSlope) {
            entityIn.m_20256_(movement);
            entityIn.f_19864_ = true;
        }
    }

    public static boolean shouldIgnoreBlocking(Entity me, Entity other) {
        if (other instanceof HangingEntity) {
            return true;
        }
        if (other.m_7752_() == PushReaction.IGNORE) {
            return true;
        }
        return BeltMovementHandler.isRidingOrBeingRiddenBy(me, other);
    }

    public static boolean isRidingOrBeingRiddenBy(Entity me, Entity other) {
        for (Entity entity : me.m_20197_()) {
            if (entity.equals((Object)other)) {
                return true;
            }
            if (!BeltMovementHandler.isRidingOrBeingRiddenBy(entity, other)) continue;
            return true;
        }
        return false;
    }

    public static class TransportedEntityInfo {
        int ticksSinceLastCollision;
        BlockPos lastCollidedPos;
        BlockState lastCollidedState;

        public TransportedEntityInfo(BlockPos collision, BlockState belt) {
            this.refresh(collision, belt);
        }

        public void refresh(BlockPos collision, BlockState belt) {
            this.ticksSinceLastCollision = 0;
            this.lastCollidedPos = new BlockPos((Vec3i)collision).m_7949_();
            this.lastCollidedState = belt;
        }

        public TransportedEntityInfo tick() {
            ++this.ticksSinceLastCollision;
            return this;
        }

        public int getTicksSinceLastCollision() {
            return this.ticksSinceLastCollision;
        }
    }
}

