/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.deployer;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemHandlerHelper;

public class BeltDeployerCallbacks {
    public static BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack s, TransportedItemStackHandlerBehaviour i, DeployerBlockEntity blockEntity) {
        ItemStack held;
        if (blockEntity.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (blockEntity.mode == DeployerBlockEntity.Mode.PUNCH) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        BlockState blockState = blockEntity.m_58900_();
        if (!blockState.m_61138_((Property)DirectionalKineticBlock.FACING) || blockState.m_61143_((Property)DirectionalKineticBlock.FACING) != Direction.DOWN) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (blockEntity.state != DeployerBlockEntity.State.WAITING) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (blockEntity.redstoneLocked) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        DeployerFakePlayer player = blockEntity.getPlayer();
        ItemStack itemStack = held = player == null ? ItemStack.f_41583_ : player.m_21205_();
        if (held.m_41619_()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (blockEntity.getRecipe(s.stack) == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        blockEntity.start();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    public static BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack s, TransportedItemStackHandlerBehaviour i, DeployerBlockEntity blockEntity) {
        ItemStack held;
        if (blockEntity.getSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        BlockState blockState = blockEntity.m_58900_();
        if (!blockState.m_61138_((Property)DirectionalKineticBlock.FACING) || blockState.m_61143_((Property)DirectionalKineticBlock.FACING) != Direction.DOWN) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        DeployerFakePlayer player = blockEntity.getPlayer();
        ItemStack itemStack = held = player == null ? ItemStack.f_41583_ : player.m_21205_();
        if (held.m_41619_()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        Recipe<? extends Container> recipe = blockEntity.getRecipe(s.stack);
        if (recipe == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (blockEntity.state == DeployerBlockEntity.State.RETRACTING && blockEntity.timer == 1000) {
            BeltDeployerCallbacks.activate(s, i, blockEntity, recipe);
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (blockEntity.state == DeployerBlockEntity.State.WAITING) {
            if (blockEntity.redstoneLocked) {
                return BeltProcessingBehaviour.ProcessingResult.PASS;
            }
            blockEntity.start();
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    public static void activate(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler, DeployerBlockEntity blockEntity, Recipe<?> recipe) {
        boolean keepHeld;
        List<TransportedItemStack> collect = RecipeApplier.applyRecipeOn(ItemHandlerHelper.copyStackWithSize((ItemStack)transported.stack, (int)1), recipe).stream().map(stack -> {
            TransportedItemStack copy = transported.copy();
            boolean centered = BeltHelper.isItemUpright(stack);
            copy.stack = stack;
            copy.locked = true;
            copy.angle = centered ? 180 : Create.RANDOM.nextInt(360);
            return copy;
        }).map(t -> {
            t.locked = false;
            return t;
        }).collect(Collectors.toList());
        blockEntity.award(AllAdvancements.DEPLOYER);
        TransportedItemStack left = transported.copy();
        blockEntity.player.spawnedItemEffects = transported.stack.m_41777_();
        left.stack.m_41774_(1);
        ItemStack resultItem = null;
        if (collect.isEmpty()) {
            resultItem = left.stack.m_41777_();
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(left));
        } else {
            resultItem = ((TransportedItemStack)collect.get((int)0)).stack.m_41777_();
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(collect, left));
        }
        ItemStack heldItem = blockEntity.player.m_21205_();
        boolean unbreakable = heldItem.m_41782_() && heldItem.m_41783_().m_128471_("Unbreakable");
        boolean bl = keepHeld = recipe instanceof ItemApplicationRecipe && ((ItemApplicationRecipe)recipe).shouldKeepHeldItem();
        if (!unbreakable && !keepHeld) {
            if (heldItem.m_41763_()) {
                heldItem.m_41622_(1, (LivingEntity)blockEntity.player, s -> s.m_21190_(InteractionHand.MAIN_HAND));
            } else {
                heldItem.m_41774_(1);
            }
        }
        if (resultItem != null && !resultItem.m_41619_()) {
            BeltDeployerCallbacks.awardAdvancements(blockEntity, resultItem);
        }
        BlockPos pos = blockEntity.m_58899_();
        Level world = blockEntity.m_58904_();
        if (heldItem.m_41619_()) {
            world.m_5594_(null, pos, SoundEvents.f_12018_, SoundSource.BLOCKS, 0.25f, 1.0f);
        }
        world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.25f, 0.75f);
        if (recipe instanceof SandPaperPolishingRecipe) {
            AllSoundEvents.SANDING_SHORT.playOnServer(world, (Vec3i)pos, 0.35f, 1.0f);
        }
        blockEntity.sendData();
    }

    private static void awardAdvancements(DeployerBlockEntity blockEntity, ItemStack created) {
        CreateAdvancement advancement = null;
        if (AllBlocks.ANDESITE_CASING.isIn(created)) {
            advancement = AllAdvancements.ANDESITE_CASING;
        } else if (AllBlocks.BRASS_CASING.isIn(created)) {
            advancement = AllAdvancements.BRASS_CASING;
        } else if (AllBlocks.COPPER_CASING.isIn(created)) {
            advancement = AllAdvancements.COPPER_CASING;
        } else if (AllBlocks.RAILWAY_CASING.isIn(created)) {
            advancement = AllAdvancements.TRAIN_CASING;
        } else {
            return;
        }
        blockEntity.award(advancement);
    }
}

