/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.waterwheel;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WaterWheelBlockEntity
extends GeneratingKineticBlockEntity {
    public static final Map<Direction.Axis, Set<BlockPos>> SMALL_OFFSETS = new EnumMap<Direction.Axis, Set<BlockPos>>(Direction.Axis.class);
    public static final Map<Direction.Axis, Set<BlockPos>> LARGE_OFFSETS = new EnumMap<Direction.Axis, Set<BlockPos>>(Direction.Axis.class);
    public int flowScore;
    public BlockState material = Blocks.f_50741_.m_49966_();

    public WaterWheelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(60);
    }

    protected int getSize() {
        return 1;
    }

    protected Set<BlockPos> getOffsetsToCheck() {
        return (this.getSize() == 1 ? SMALL_OFFSETS : LARGE_OFFSETS).get(this.getAxis());
    }

    public InteractionResult applyMaterialIfValid(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return InteractionResult.PASS;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockState material = blockItem.m_40614_().m_49966_();
        if (material == this.material) {
            return InteractionResult.PASS;
        }
        if (!material.m_204336_(BlockTags.f_13090_)) {
            return InteractionResult.PASS;
        }
        if (this.f_58857_.m_5776_() && !this.isVirtual()) {
            return InteractionResult.SUCCESS;
        }
        this.material = material;
        this.notifyUpdate();
        this.f_58857_.m_46796_(2001, this.f_58858_, Block.m_49956_((BlockState)material));
        return InteractionResult.SUCCESS;
    }

    protected Direction.Axis getAxis() {
        Direction.Axis axis = Direction.Axis.X;
        BlockState blockState = this.m_58900_();
        Block block = blockState.m_60734_();
        if (block instanceof IRotate) {
            IRotate irotate = (IRotate)block;
            axis = irotate.getRotationAxis(blockState);
        }
        return axis;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.determineAndApplyFlowScore();
    }

    public void determineAndApplyFlowScore() {
        Vec3 wheelPlane = Vec3.m_82528_((Vec3i)new Vec3i(1, 1, 1).m_141950_(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.getAxis()).m_122436_()));
        int flowScore = 0;
        boolean lava = false;
        for (BlockPos blockPos : this.getOffsetsToCheck()) {
            Vec3 normal;
            Vec3 positiveMotion;
            double dot;
            BlockPos targetPos = blockPos.m_141952_((Vec3i)this.f_58858_);
            Vec3 flowAtPos = this.getFlowVectorAtPosition(targetPos).m_82559_(wheelPlane);
            lava |= FluidHelper.isLava(this.f_58857_.m_6425_(targetPos).m_76152_());
            if (flowAtPos.m_82556_() == 0.0 || !(Math.abs(dot = (flowAtPos = flowAtPos.m_82541_()).m_82526_(positiveMotion = VecHelper.rotate(normal = Vec3.m_82528_((Vec3i)blockPos).m_82541_(), 90.0, this.getAxis()))) > 0.5)) continue;
            flowScore = (int)((double)flowScore + Math.signum(dot));
        }
        if (flowScore != 0 && !this.f_58857_.m_5776_()) {
            this.award(lava ? AllAdvancements.LAVA_WHEEL : AllAdvancements.WATER_WHEEL);
        }
        this.setFlowScoreAndUpdate(flowScore);
    }

    public Vec3 getFlowVectorAtPosition(BlockPos pos) {
        FluidState fluid = this.f_58857_.m_6425_(pos);
        Vec3 vec = fluid.m_76179_((BlockGetter)this.f_58857_, pos);
        BlockState blockState = this.f_58857_.m_8055_(pos);
        if (blockState.m_60734_() == Blocks.f_50628_) {
            vec = new Vec3(0.0, (Boolean)blockState.m_61143_((Property)BubbleColumnBlock.f_50956_) != false ? -1.0 : 1.0, 0.0);
        }
        return vec;
    }

    public void setFlowScoreAndUpdate(int score) {
        if (this.flowScore == score) {
            return;
        }
        this.flowScore = score;
        this.updateGeneratedRotation();
        this.m_6596_();
    }

    private void redraw() {
        if (!this.isVirtual()) {
            this.requestModelDataUpdate();
        }
        if (this.m_58898_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            this.f_58857_.m_7726_().m_7827_().m_142202_(this.f_58858_);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.LAVA_WHEEL, AllAdvancements.WATER_WHEEL);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.flowScore = compound.m_128451_("FlowScore");
        BlockState prevMaterial = this.material;
        if (!compound.m_128441_("Material")) {
            return;
        }
        this.material = NbtUtils.m_129241_((CompoundTag)compound.m_128469_("Material"));
        if (this.material.m_60795_()) {
            this.material = Blocks.f_50741_.m_49966_();
        }
        if (clientPacket && prevMaterial != this.material) {
            this.redraw();
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("FlowScore", this.flowScore);
        compound.m_128365_("Material", (Tag)NbtUtils.m_129202_((BlockState)this.material));
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_).m_82400_((double)this.getSize());
    }

    @Override
    public float getGeneratedSpeed() {
        return Mth.m_14045_((int)this.flowScore, (int)-1, (int)1) * 8 / this.getSize();
    }

    static {
        for (Direction.Axis axis : Iterate.axes) {
            HashSet<BlockPos> offsets = new HashSet<BlockPos>();
            for (Direction d : Iterate.directions) {
                if (d.m_122434_() == axis) continue;
                offsets.add(BlockPos.f_121853_.m_142300_(d));
            }
            SMALL_OFFSETS.put(axis, offsets);
            offsets = new HashSet();
            for (Direction d : Iterate.directions) {
                if (d.m_122434_() == axis) continue;
                BlockPos centralOffset = BlockPos.f_121853_.m_5484_(d, 2);
                offsets.add(centralOffset);
                for (Direction d2 : Iterate.directions) {
                    if (d2.m_122434_() == axis || d2.m_122434_() == d.m_122434_()) continue;
                    offsets.add(centralOffset.m_142300_(d2));
                }
            }
            LARGE_OFFSETS.put(axis, offsets);
        }
    }
}

