/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.depot;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.logistics.depot.EjectorBlockEntity;
import com.simibubi.create.content.logistics.depot.EjectorTriggerPacket;
import com.simibubi.create.content.logistics.depot.SharedDepotBlockMethods;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EjectorBlock
extends HorizontalKineticBlock
implements IBE<EjectorBlockEntity>,
ProperWaterloggedBlock {
    public EjectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{WATERLOGGED}));
    }

    public FluidState m_5888_(BlockState pState) {
        return this.fluidState(pState);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return pState;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return this.withWater(super.m_5573_(pContext), pContext);
    }

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return AllShapes.CASING_13PX.get(Direction.UP);
    }

    public float getFriction(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        return this.getBlockEntityOptional((BlockGetter)world, pos).filter(ete -> ete.state == EjectorBlockEntity.State.LAUNCHING).map($ -> Float.valueOf(1.0f)).orElse(Float.valueOf(super.getFriction(state, world, pos, entity))).floatValue();
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        this.withBlockEntityDo((BlockGetter)world, pos, EjectorBlockEntity::updateSignal);
    }

    public void m_142072_(Level p_180658_1_, BlockState p_152427_, BlockPos p_180658_2_, Entity p_180658_3_, float p_180658_4_) {
        Optional blockEntityOptional = this.getBlockEntityOptional((BlockGetter)p_180658_1_, p_180658_2_);
        if (blockEntityOptional.isPresent() && !p_180658_3_.m_20162_()) {
            p_180658_3_.m_142535_(p_180658_4_, 1.0f, DamageSource.f_19315_);
            return;
        }
        super.m_142072_(p_180658_1_, p_152427_, p_180658_2_, p_180658_3_, p_180658_4_);
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        BlockPos position = entityIn.m_142538_();
        if (!AllBlocks.WEIGHTED_EJECTOR.has(worldIn.m_8055_(position))) {
            return;
        }
        if (!entityIn.m_6084_()) {
            return;
        }
        if (entityIn.m_20162_()) {
            return;
        }
        if (entityIn instanceof ItemEntity) {
            SharedDepotBlockMethods.onLanded(worldIn, entityIn);
            return;
        }
        Optional teProvider = this.getBlockEntityOptional(worldIn, position);
        if (!teProvider.isPresent()) {
            return;
        }
        EjectorBlockEntity ejectorBlockEntity = (EjectorBlockEntity)teProvider.get();
        if (ejectorBlockEntity.getState() == EjectorBlockEntity.State.RETRACTING) {
            return;
        }
        if (ejectorBlockEntity.powered) {
            return;
        }
        if (ejectorBlockEntity.launcher.getHorizontalDistance() == 0) {
            return;
        }
        if (entityIn.m_20096_()) {
            entityIn.m_6853_(false);
            Vec3 center = VecHelper.getCenterOf((Vec3i)position).m_82520_(0.0, 0.4375, 0.0);
            Vec3 positionVec = entityIn.m_20182_();
            double diff = center.m_82554_(positionVec);
            entityIn.m_20334_(0.0, -0.125, 0.0);
            Vec3 vec = center.m_82549_(positionVec).m_82490_(0.5);
            if (diff > 0.25) {
                entityIn.m_6034_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
                return;
            }
        }
        ejectorBlockEntity.activate();
        ejectorBlockEntity.notifyUpdate();
        if (entityIn.f_19853_.f_46443_) {
            AllPackets.getChannel().sendToServer((Object)new EjectorTriggerPacket(ejectorBlockEntity.m_58899_()));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (AllItems.WRENCH.isIn(player.m_21120_(hand))) {
            return InteractionResult.PASS;
        }
        return SharedDepotBlockMethods.onUse(state, world, pos, player, hand, ray);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122427_().m_122434_();
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return this.getRotationAxis(state) == face.m_122434_();
    }

    @Override
    public Class<EjectorBlockEntity> getBlockEntityClass() {
        return EjectorBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends EjectorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.WEIGHTED_EJECTOR.get();
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return SharedDepotBlockMethods.getComparatorInputOverride(blockState, worldIn, pos);
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }
}

