/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.sequenced;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipeSerializer;
import com.simibubi.create.content.processing.sequenced.SequencedRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class SequencedAssemblyRecipeBuilder {
    private SequencedAssemblyRecipe recipe;
    protected List<ICondition> recipeConditions = new ArrayList<ICondition>();

    public SequencedAssemblyRecipeBuilder(ResourceLocation id) {
        this.recipe = new SequencedAssemblyRecipe(id, (SequencedAssemblyRecipeSerializer)((Object)AllRecipeTypes.SEQUENCED_ASSEMBLY.getSerializer()));
    }

    public <T extends ProcessingRecipe<?>> SequencedAssemblyRecipeBuilder addStep(ProcessingRecipeBuilder.ProcessingRecipeFactory<T> factory, UnaryOperator<ProcessingRecipeBuilder<T>> builder) {
        ProcessingRecipeBuilder<T> recipeBuilder = new ProcessingRecipeBuilder<T>(factory, new ResourceLocation("dummy"));
        Item placeHolder = this.recipe.getTransitionalItem().m_41720_();
        this.recipe.getSequence().add(new SequencedRecipe(((ProcessingRecipeBuilder)builder.apply(recipeBuilder.require((ItemLike)placeHolder).output((ItemLike)placeHolder))).build()));
        return this;
    }

    public SequencedAssemblyRecipeBuilder require(ItemLike ingredient) {
        return this.require(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}));
    }

    public SequencedAssemblyRecipeBuilder require(TagKey<Item> tag) {
        return this.require(Ingredient.m_204132_(tag));
    }

    public SequencedAssemblyRecipeBuilder require(Ingredient ingredient) {
        this.recipe.ingredient = ingredient;
        return this;
    }

    public SequencedAssemblyRecipeBuilder transitionTo(ItemLike item) {
        this.recipe.transitionalItem = new ProcessingOutput(new ItemStack(item), 1.0f);
        return this;
    }

    public SequencedAssemblyRecipeBuilder loops(int loops) {
        this.recipe.loops = loops;
        return this;
    }

    public SequencedAssemblyRecipeBuilder addOutput(ItemLike item, float weight) {
        return this.addOutput(new ItemStack(item), weight);
    }

    public SequencedAssemblyRecipeBuilder addOutput(ItemStack item, float weight) {
        this.recipe.resultPool.add(new ProcessingOutput(item, weight));
        return this;
    }

    public SequencedAssemblyRecipe build() {
        return this.recipe;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new DataGenResult(this.build(), this.recipeConditions));
    }

    public static class DataGenResult
    implements FinishedRecipe {
        private SequencedAssemblyRecipe recipe;
        private List<ICondition> recipeConditions;
        private ResourceLocation id;
        private SequencedAssemblyRecipeSerializer serializer;

        public DataGenResult(SequencedAssemblyRecipe recipe, List<ICondition> recipeConditions) {
            this.recipeConditions = recipeConditions;
            this.recipe = recipe;
            this.id = new ResourceLocation(recipe.m_6423_().m_135827_(), AllRecipeTypes.SEQUENCED_ASSEMBLY.getId().m_135815_() + "/" + recipe.m_6423_().m_135815_());
            this.serializer = (SequencedAssemblyRecipeSerializer)recipe.m_7707_();
        }

        public void m_7917_(JsonObject json) {
            this.serializer.write(json, this.recipe);
            if (this.recipeConditions.isEmpty()) {
                return;
            }
            JsonArray conds = new JsonArray();
            this.recipeConditions.forEach(c -> conds.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            json.add("conditions", (JsonElement)conds);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

