/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.network.message;

import com.mrcrayfish.furniture.common.mail.Mail;
import com.mrcrayfish.furniture.common.mail.PostOffice;
import com.mrcrayfish.furniture.inventory.container.PostBoxMenu;
import com.mrcrayfish.furniture.network.message.IMessage;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class MessageSendMail
implements IMessage<MessageSendMail> {
    private UUID playerId;
    private UUID mailBoxId;

    public MessageSendMail() {
    }

    public MessageSendMail(UUID playerId, UUID mailBoxId) {
        this.playerId = playerId;
        this.mailBoxId = mailBoxId;
    }

    @Override
    public void encode(MessageSendMail message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.playerId);
        buffer.m_130077_(message.mailBoxId);
    }

    @Override
    public MessageSendMail decode(FriendlyByteBuf buffer) {
        return new MessageSendMail(buffer.m_130259_(), buffer.m_130259_());
    }

    @Override
    public void handle(MessageSendMail message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            PostBoxMenu container;
            ServerPlayer entity = ((NetworkEvent.Context)supplier.get()).getSender();
            if (entity != null && entity.f_36096_ instanceof PostBoxMenu && !(container = (PostBoxMenu)entity.f_36096_).getMail().m_41619_()) {
                Mail mail = new Mail("Yo", container.getMail(), entity.m_7755_().getString());
                if (PostOffice.sendMailToPlayer(message.playerId, message.mailBoxId, mail)) {
                    container.removeMail();
                } else {
                    entity.m_6352_((Component)new TranslatableComponent("message.cfm.mail_queue_full"), this.playerId);
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

