/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.handler;

import com.mrcrayfish.guns.GunMod;
import com.mrcrayfish.guns.client.handler.ControllerHandler;
import com.mrcrayfish.guns.client.handler.GunRenderingHandler;
import com.mrcrayfish.guns.client.util.PropertyHelper;
import com.mrcrayfish.guns.common.GripType;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.compat.PlayerReviveHelper;
import com.mrcrayfish.guns.debug.Debug;
import com.mrcrayfish.guns.init.ModBlocks;
import com.mrcrayfish.guns.init.ModSyncedDataKeys;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.C2SMessageAim;
import com.mrcrayfish.guns.util.GunEnchantmentHelper;
import com.mrcrayfish.guns.util.GunModifierHelper;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AimingHandler {
    private static AimingHandler instance;
    private static final double MAX_AIM_PROGRESS = 5.0;
    private final AimTracker localTracker = new AimTracker();
    private final Map<Player, AimTracker> aimingMap = new WeakHashMap<Player, AimTracker>();
    private double normalisedAdsProgress;
    private boolean aiming = false;

    public static AimingHandler get() {
        if (instance == null) {
            instance = new AimingHandler();
        }
        return instance;
    }

    private AimingHandler() {
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        AimTracker tracker = this.getAimTracker(player);
        if (tracker != null) {
            tracker.handleAiming(player, player.m_21120_(InteractionHand.MAIN_HAND));
            if (!tracker.isAiming()) {
                this.aimingMap.remove(player);
            }
        }
    }

    @Nullable
    private AimTracker getAimTracker(Player player) {
        if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue() && !this.aimingMap.containsKey(player)) {
            this.aimingMap.put(player, new AimTracker());
        }
        return this.aimingMap.get(player);
    }

    public float getAimProgress(Player player, float partialTicks) {
        if (player.m_7578_()) {
            return (float)this.localTracker.getNormalProgress(partialTicks);
        }
        AimTracker tracker = this.getAimTracker(player);
        if (tracker != null) {
            return (float)tracker.getNormalProgress(partialTicks);
        }
        return 0.0f;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (this.isAiming()) {
            if (!this.aiming) {
                ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)true);
                PacketHandler.getPlayChannel().sendToServer((Object)new C2SMessageAim(true));
                this.aiming = true;
            }
        } else if (this.aiming) {
            ModSyncedDataKeys.AIMING.setValue((Entity)player, (Object)false);
            PacketHandler.getPlayChannel().sendToServer((Object)new C2SMessageAim(false));
            this.aiming = false;
        }
        this.localTracker.handleAiming((Player)player, player.m_21120_(InteractionHand.MAIN_HAND));
    }

    @SubscribeEvent
    public void onFovUpdate(EntityViewRenderEvent.FieldOfView event) {
        if (!GunRenderingHandler.get().getUsedConfiguredFov()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91074_.m_21205_().m_41619_() || mc.f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            return;
        }
        ItemStack heldItem = mc.f_91074_.m_21205_();
        Item item = heldItem.m_41720_();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        if (AimingHandler.get().getNormalisedAdsProgress() == 0.0) {
            return;
        }
        if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)mc.f_91074_)).booleanValue()) {
            return;
        }
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (modifiedGun.getModules().getZoom() == null) {
            return;
        }
        double time = PropertyHelper.getSightAnimations(heldItem, modifiedGun).getFovCurve().apply(this.normalisedAdsProgress);
        float modifier = Gun.getFovModifier(heldItem, modifiedGun);
        modifier = (1.0f - modifier) * (float)time;
        event.setFOV(event.getFOV() - event.getFOV() * (double)modifier);
    }

    @SubscribeEvent
    public void onClientTick(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.aimingMap.clear();
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onRenderOverlay(RenderGameOverlayEvent event) {
        this.normalisedAdsProgress = this.localTracker.getNormalProgress(event.getPartialTicks());
    }

    public boolean isZooming() {
        return this.aiming;
    }

    public boolean isAiming() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return false;
        }
        if (mc.f_91074_.m_5833_()) {
            return false;
        }
        if (Debug.isForceAim()) {
            return true;
        }
        if (mc.f_91080_ != null) {
            return false;
        }
        if (PlayerReviveHelper.isBleeding((Player)mc.f_91074_)) {
            return false;
        }
        ItemStack heldItem = mc.f_91074_.m_21205_();
        if (!(heldItem.m_41720_() instanceof GunItem)) {
            return false;
        }
        Gun gun = ((GunItem)heldItem.m_41720_()).getModifiedGun(heldItem);
        if (!gun.canAimDownSight()) {
            return false;
        }
        if (mc.f_91074_.m_21206_().m_41720_() == Items.f_42740_ && gun.getGeneral().getGripType() == GripType.ONE_HANDED) {
            return false;
        }
        if (!this.localTracker.isAiming() && this.isLookingAtInteractableBlock()) {
            return false;
        }
        if (((Boolean)ModSyncedDataKeys.RELOADING.getValue((Entity)mc.f_91074_)).booleanValue()) {
            return false;
        }
        boolean zooming = mc.f_91066_.f_92095_.m_90857_();
        if (GunMod.controllableLoaded) {
            zooming |= ControllerHandler.isAiming();
        }
        return zooming;
    }

    public boolean isLookingAtInteractableBlock() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91077_ != null && mc.f_91073_ != null) {
            HitResult hitResult = mc.f_91077_;
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult result = (BlockHitResult)hitResult;
                BlockState state = mc.f_91073_.m_8055_(result.m_82425_());
                Block block = state.m_60734_();
                return block instanceof EntityBlock || block == Blocks.f_50091_ || block == ModBlocks.WORKBENCH.get() || state.m_204336_(BlockTags.f_13103_) || state.m_204336_(BlockTags.f_13036_) || state.m_204336_(Tags.Blocks.CHESTS) || state.m_204336_(Tags.Blocks.FENCE_GATES);
            }
            hitResult = mc.f_91077_;
            if (hitResult instanceof EntityHitResult) {
                EntityHitResult result = (EntityHitResult)hitResult;
                return result.m_82443_() instanceof ItemFrame;
            }
        }
        return false;
    }

    public double getNormalisedAdsProgress() {
        return this.normalisedAdsProgress;
    }

    public class AimTracker {
        private double currentAim;
        private double previousAim;

        private void handleAiming(Player player, ItemStack heldItem) {
            this.previousAim = this.currentAim;
            if (((Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player)).booleanValue() || player.m_7578_() && AimingHandler.this.isAiming()) {
                if (this.currentAim < 5.0) {
                    double speed = GunEnchantmentHelper.getAimDownSightSpeed(heldItem);
                    speed = GunModifierHelper.getModifiedAimDownSightSpeed(heldItem, speed);
                    this.currentAim += speed;
                    if (this.currentAim > 5.0) {
                        this.currentAim = 5.0;
                    }
                }
            } else if (this.currentAim > 0.0) {
                double speed = GunEnchantmentHelper.getAimDownSightSpeed(heldItem);
                speed = GunModifierHelper.getModifiedAimDownSightSpeed(heldItem, speed);
                this.currentAim -= speed;
                if (this.currentAim < 0.0) {
                    this.currentAim = 0.0;
                }
            }
        }

        public boolean isAiming() {
            return this.currentAim != 0.0 || this.previousAim != 0.0;
        }

        public double getNormalProgress(float partialTicks) {
            return Mth.m_14008_((double)((this.previousAim + (this.currentAim - this.previousAim) * (double)partialTicks) / 5.0), (double)0.0, (double)1.0);
        }
    }
}

