/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.util;

import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.init.ModEnchantments;
import com.mrcrayfish.guns.particles.TrailData;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class GunEnchantmentHelper {
    public static ParticleOptions getParticle(ItemStack weapon) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)weapon);
        if (enchantments.containsKey(ModEnchantments.FIRE_STARTER.get())) {
            return ParticleTypes.f_123756_;
        }
        if (enchantments.containsKey(ModEnchantments.PUNCTURING.get())) {
            return ParticleTypes.f_123808_;
        }
        return new TrailData(weapon.m_41793_());
    }

    public static int getReloadInterval(ItemStack weapon) {
        int interval = 10;
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.QUICK_HANDS.get()), (ItemStack)weapon);
        if (level > 0) {
            interval -= 3 * level;
        }
        return Math.max(interval, 1);
    }

    public static int getRate(ItemStack weapon, Gun modifiedGun) {
        int rate = modifiedGun.getGeneral().getRate();
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.TRIGGER_FINGER.get()), (ItemStack)weapon);
        if (level > 0) {
            float newRate = (float)rate * (0.25f * (float)level);
            rate = (int)((float)rate - Mth.m_14036_((float)newRate, (float)0.0f, (float)rate));
        }
        return rate;
    }

    public static double getAimDownSightSpeed(ItemStack weapon) {
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.LIGHTWEIGHT.get()), (ItemStack)weapon);
        return level > 0 ? 1.5 : 1.0;
    }

    public static int getAmmoCapacity(ItemStack weapon, Gun modifiedGun) {
        int capacity = modifiedGun.getGeneral().getMaxAmmo();
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.OVER_CAPACITY.get()), (ItemStack)weapon);
        if (level > 0) {
            capacity += Math.max(level, capacity / 2 * level);
        }
        return capacity;
    }

    public static double getProjectileSpeedModifier(ItemStack weapon) {
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.ACCELERATOR.get()), (ItemStack)weapon);
        if (level > 0) {
            return 1.0 + 0.5 * (double)level;
        }
        return 1.0;
    }

    public static float getAcceleratorDamage(ItemStack weapon, float damage) {
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.ACCELERATOR.get()), (ItemStack)weapon);
        if (level > 0) {
            return damage + damage * (0.1f * (float)level);
        }
        return damage;
    }

    public static float getPuncturingChance(ItemStack weapon) {
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModEnchantments.PUNCTURING.get()), (ItemStack)weapon);
        return (float)level * 0.05f;
    }
}

