/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import com.google.common.collect.Sets;
import dev.itsmeow.betteranimalsplus.api.ModEventBus;
import dev.itsmeow.betteranimalsplus.common.entity.ai.WaterfowlNavigator;
import dev.itsmeow.betteranimalsplus.common.entity.util.EntityUtil;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IVariantTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModItems;
import dev.itsmeow.betteranimalsplus.init.ModSoundEvents;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityGoose
extends EntityAnimalWithTypes {
    public int attacksLeft = 0;
    public int lastAttackTime = 0;
    protected final Set<UUID> dislikedPlayers = new HashSet<UUID>();
    private int eatTicks;
    private static final Predicate<ItemEntity> ITEM_SELECTOR = item -> !item.m_32063_() && item.m_6084_();
    public int timeUntilNextEgg;
    public static final String PICKUP_BLOCK_LIST_KEY = "pickup_blacklist";
    private static final Set<Item> BREEDING_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.f_42577_, Items.f_42404_, Items.f_42733_, Items.f_42578_, Items.f_41867_});
    private static final String[] ONE_STR = new String[]{"1"};
    private static final String[] TWO_THREE_STR = new String[]{"2", "3"};
    private static final String[] ONE_TWO_THREE_STR = new String[]{"1", "2", "3"};

    public EntityGoose(EntityType<? extends EntityGoose> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.m_21553_(true);
        this.timeUntilNextEgg = this.f_19796_.nextInt(6000) + 6000;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new WaterfowlNavigator((Mob)this, worldIn);
    }

    protected float m_6108_() {
        return 0.95f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.4){

            public boolean m_8036_() {
                return this.f_25684_.m_5448_() == null && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42577_, Items.f_42404_, Items.f_42733_, Items.f_42578_, Items.f_41867_, Items.f_42406_}), false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new FindItemsGoal());
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, false){

            public void m_8056_() {
                EntityGoose.this.attacksLeft = this.f_25540_.m_21187_().nextInt(4) + 1;
                super.m_8056_();
            }

            public boolean m_8036_() {
                return super.m_8036_() && this.f_25540_.f_19797_ - EntityGoose.this.lastAttackTime > 150 && !EntityGoose.this.isPassive();
            }

            public boolean m_8045_() {
                return EntityGoose.this.attacksLeft > 0 && super.m_8045_();
            }

            protected void m_6739_(LivingEntity p_190102_1_, double p_190102_2_) {
                if (EntityGoose.this.attacksLeft > 0) {
                    super.m_6739_(p_190102_1_, p_190102_2_);
                } else {
                    this.m_8041_();
                }
            }

            public void m_8041_() {
                super.m_8041_();
                if (EntityGoose.this.attacksLeft <= 0) {
                    this.f_25540_.m_6710_(null);
                }
            }
        });
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                return super.m_8036_() && !EntityGoose.this.isPassive();
            }
        }.m_26044_(new Class[]{EntityGoose.class}));
        this.f_21346_.m_25352_(1, (Goal)new DislikeTargetGoal(this){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !EntityGoose.this.isPassive();
            }
        });
    }

    public boolean m_6898_(ItemStack itemStack) {
        return BREEDING_ITEMS.contains(itemStack.m_41720_());
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_;
    }

    protected boolean isPassive() {
        return this.getVariantString().equals("1") || this.f_19853_.m_46791_() == Difficulty.PEACEFUL;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack;
            if (this.m_6084_() && this.m_6142_() && (itemstack = this.m_6844_(EquipmentSlot.MAINHAND)).m_41720_().m_41472_() && this.m_5448_() == null) {
                ++this.eatTicks;
                if (this.eatTicks > 200) {
                    ItemStack itemstack1;
                    if (itemstack.m_41720_() == Items.f_42406_) {
                        this.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 900));
                    }
                    if (!(itemstack1 = itemstack.m_41671_(this.f_19853_, (LivingEntity)this)).m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, itemstack1);
                    }
                    this.eatTicks = 0;
                } else if (this.eatTicks > 160 && this.f_19796_.nextFloat() < 0.1f) {
                    this.m_5496_(this.m_7866_(itemstack), 1.0f, 1.0f);
                    this.f_19853_.m_7605_((Entity)this, (byte)45);
                }
            }
            if (!this.m_6162_() && ModEventBus.LayEggTickEvent.emit((LivingEntity)this) && --this.timeUntilNextEgg <= 0) {
                this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
                this.m_20000_(this.m_21187_().nextInt(128) == 0 ? (ItemLike)ModItems.GOLDEN_GOOSE_EGG.get() : (ItemLike)ModItems.GOOSE_EGG.get(), 1);
                this.timeUntilNextEgg = this.f_19796_.nextInt(6000) + 6000;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 45) {
            ItemStack stack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!stack.m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3d = new Vec3(((double)this.f_19796_.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                    this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20186_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_);
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    public void m_6710_(LivingEntity entity) {
        super.m_6710_(entity);
        if (entity instanceof Player) {
            UUID uuid = ((Player)entity).m_36316_().getId();
            this.dislikedPlayers.add(uuid);
        }
    }

    public boolean m_7327_(Entity entityIn) {
        if (this.attacksLeft > 0) {
            --this.attacksLeft;
        }
        this.lastAttackTime = this.f_19797_;
        return super.m_7327_(entityIn);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() != null && source.m_7639_() != null && source.m_7639_() == this.m_5448_()) {
            this.lastAttackTime = 0;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_6668_(DamageSource damageSourceIn) {
        ItemStack itemstack = this.m_6844_(EquipmentSlot.MAINHAND);
        if (!itemstack.m_41619_()) {
            this.m_19983_(itemstack);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        super.m_6668_(damageSourceIn);
    }

    public boolean m_7066_(ItemStack stack) {
        EquipmentSlot type = Mob.m_147233_((ItemStack)stack);
        if (!this.m_6844_(type).m_41619_()) {
            return false;
        }
        return type == EquipmentSlot.MAINHAND && super.m_7066_(stack);
    }

    public boolean m_7252_(ItemStack newStack) {
        ItemStack oldStack = this.m_6844_(EquipmentSlot.MAINHAND);
        return !this.isPickupBlacklisted(newStack.m_41720_()) && (oldStack.m_41619_() || this.eatTicks == 0 && newStack.m_41720_().m_41472_() && !oldStack.m_41720_().m_41472_());
    }

    public boolean isPickupBlacklisted(Item item) {
        for (String itemsId : this.getContainer().getCustomConfiguration().getAnyHolder(List.class, PICKUP_BLOCK_LIST_KEY).get()) {
            if (!(itemsId.startsWith("#") ? item.m_204114_().m_203656_(TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(itemsId.substring(1)))) : itemsId.equals(Registry.f_122827_.m_7981_((Object)item).toString()))) continue;
            return true;
        }
        return false;
    }

    private void dropItem(ItemStack stack) {
        if (!stack.m_41619_() && !this.f_19853_.f_46443_) {
            ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_() + this.m_20154_().f_82479_, this.m_20186_() + 1.0, this.m_20189_() + this.m_20154_().f_82481_, stack);
            itementity.m_32010_(40);
            itementity.m_32052_(this.m_142081_());
            this.m_5496_(SoundEvents.f_11952_, 1.0f, 1.0f);
            this.f_19853_.m_7967_((Entity)itementity);
        }
    }

    private void spawnItem(ItemStack stack) {
        ItemEntity entity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.f_19853_.m_7967_((Entity)entity);
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.GOOSE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModSoundEvents.GOOSE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.GOOSE_DEATH.get();
    }

    protected void m_7581_(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.m_32055_();
        if (this.m_7252_(stack)) {
            int i = stack.m_41613_();
            if (i > 1) {
                this.spawnItem(stack.m_41620_(i - 1));
            }
            this.dropItem(this.m_6844_(EquipmentSlot.MAINHAND));
            this.m_8061_(EquipmentSlot.MAINHAND, stack.m_41620_(1));
            this.f_21347_[EquipmentSlot.MAINHAND.m_20749_()] = 2.0f;
            this.m_7938_((Entity)itemEntity, stack.m_41613_());
            itemEntity.m_146870_();
            this.eatTicks = 0;
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ListTag list = new ListTag();
        for (UUID uuid : this.dislikedPlayers) {
            list.add((Object)StringTag.m_129297_((String)uuid.toString()));
        }
        compound.m_128365_("disliked_players", (Tag)list);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        compound.m_128437_("disliked_players", 8).forEach(nbt -> this.dislikedPlayers.add(UUID.fromString(nbt.m_7916_())));
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingdata, CompoundTag compound) {
        String[] types = switch (reason) {
            case MobSpawnType.NATURAL, MobSpawnType.CHUNK_GENERATION, MobSpawnType.STRUCTURE -> TWO_THREE_STR;
            case MobSpawnType.BREEDING -> ONE_STR;
            default -> ONE_TWO_THREE_STR;
        };
        livingdata = EntityUtil.childChance((AgeableMob)this, reason, livingdata, 0.25f);
        IVariant variant = this.getContainer().getVariantForName(types[this.m_21187_().nextInt(types.length)]).get();
        if (livingdata instanceof IVariantTypes.AgeableTypeData) {
            variant = ((IVariantTypes.AgeableTypeData)((Object)livingdata)).typeData;
        } else {
            livingdata = livingdata instanceof AgeableMob.AgeableMobGroupData ? new IVariantTypes.AgeableTypeData((AgeableMob.AgeableMobGroupData)livingdata, variant) : new IVariantTypes.AgeableTypeData(variant);
        }
        this.setType(variant);
        return livingdata;
    }

    public static boolean canGooseSpawn(EntityType<EntityGoose> type, LevelAccessor world, MobSpawnType reason, BlockPos pos, Random rand) {
        Block downBlock = world.m_8055_(pos.m_7495_()).m_60734_();
        return (downBlock == Blocks.f_50440_ && EntityGoose.nearWater(world, pos) || downBlock == Blocks.f_49990_) && world.m_45524_(pos, 0) > 8 && world.m_46859_(pos);
    }

    protected static boolean nearWater(LevelAccessor world, BlockPos pos) {
        int i = 12;
        int j = 2;
        BlockPos.MutableBlockPos newpos = new BlockPos.MutableBlockPos();
        int k = 0;
        while (k <= j) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        newpos.m_122190_((Vec3i)pos).m_122184_(i1, k - 1, j1);
                        if (newpos.m_123341_() >> 4 == pos.m_123341_() >> 4 && newpos.m_123343_() >> 4 == pos.m_123343_() >> 4 && world.m_8055_((BlockPos)newpos).m_60734_() == Blocks.f_49990_) {
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return false;
    }

    @Override
    protected EntityGoose getBaseChild() {
        return (EntityGoose)this.getContainer().getEntityType().m_20615_(this.f_19853_);
    }

    @Override
    public EntityTypeContainer<EntityGoose> getContainer() {
        return ModEntities.GOOSE;
    }

    public class FindItemsGoal
    extends Goal {
        public FindItemsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!EntityGoose.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                return false;
            }
            if (EntityGoose.this.m_5448_() == null && EntityGoose.this.m_142581_() == null) {
                if (EntityGoose.this.m_21187_().nextInt(10) != 0) {
                    return false;
                }
                List list = EntityGoose.this.f_19853_.m_6443_(ItemEntity.class, EntityGoose.this.m_142469_().m_82377_(8.0, 8.0, 8.0), ITEM_SELECTOR);
                return !list.isEmpty() && EntityGoose.this.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
            }
            return false;
        }

        public void m_8037_() {
            List list = EntityGoose.this.f_19853_.m_6443_(ItemEntity.class, EntityGoose.this.m_142469_().m_82377_(8.0, 8.0, 8.0), ITEM_SELECTOR);
            ItemStack itemstack = EntityGoose.this.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41619_() && !list.isEmpty()) {
                EntityGoose.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }

        public void m_8056_() {
            List list = EntityGoose.this.f_19853_.m_6443_(ItemEntity.class, EntityGoose.this.m_142469_().m_82377_(8.0, 8.0, 8.0), ITEM_SELECTOR);
            if (!list.isEmpty()) {
                EntityGoose.this.m_21573_().m_5624_((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    public class DislikeTargetGoal
    extends TargetGoal {
        protected EntityGoose goose;

        public DislikeTargetGoal(EntityGoose goose) {
            super((Mob)goose, true);
            this.goose = goose;
        }

        public boolean m_8036_() {
            return this.goose.dislikedPlayers.size() > 0 && this.goose.m_5448_() == null && this.goose.f_19797_ - this.goose.lastAttackTime > 150;
        }

        protected boolean m_26150_(LivingEntity potentialTarget, TargetingConditions targetPredicate) {
            return potentialTarget instanceof Player && super.m_26150_(potentialTarget, targetPredicate) && EntityGoose.this.dislikedPlayers.contains(((Player)potentialTarget).m_36316_().getId());
        }
    }
}

