/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import blusunrize.immersiveengineering.client.utils.GuiHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import flaxbeard.immersivepetroleum.client.render.IPRenderTypes;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.OilTankTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="immersivepetroleum", bus=Mod.EventBusSubscriber.Bus.MOD)
public class OilTankRenderer
implements BlockEntityRenderer<OilTankTileEntity> {
    public boolean shouldRenderOffScreen(@Nonnull OilTankTileEntity te) {
        return true;
    }

    public void render(OilTankTileEntity te, float partialTicks, @Nonnull PoseStack matrix, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        FluidStack fs;
        if (!te.formed || te.isDummy() || !te.getLevelNonnull().m_46805_(te.m_58899_())) {
            return;
        }
        combinedOverlay = OverlayTexture.f_118083_;
        matrix.m_85836_();
        switch (te.getFacing()) {
            case EAST: {
                matrix.m_85845_(new Quaternion(0.0f, 270.0f, 0.0f, true));
                matrix.m_85837_(0.0, 0.0, -1.0);
                break;
            }
            case SOUTH: {
                matrix.m_85845_(new Quaternion(0.0f, 180.0f, 0.0f, true));
                matrix.m_85837_(-1.0, 0.0, -1.0);
                break;
            }
            case WEST: {
                matrix.m_85845_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                matrix.m_85837_(-1.0, 0.0, 0.0);
                break;
            }
        }
        matrix.m_85836_();
        matrix.m_85837_(1.0, 2.0, (double)2.995f);
        Matrix4f mat = matrix.m_85850_().m_85861_();
        VertexConsumer builder = buffer.m_6299_(IPRenderTypes.TRANSLUCENT_POSITION_COLOR);
        builder.m_85982_(mat, 1.5f, -0.5f, 0.0f).m_6122_(34, 34, 34, 255).m_5752_();
        builder.m_85982_(mat, 1.5f, 1.0f, 0.0f).m_6122_(34, 34, 34, 255).m_5752_();
        builder.m_85982_(mat, 0.0f, 1.0f, 0.0f).m_6122_(34, 34, 34, 255).m_5752_();
        builder.m_85982_(mat, 0.0f, -0.5f, 0.0f).m_6122_(34, 34, 34, 255).m_5752_();
        OilTankTileEntity master = (OilTankTileEntity)te.master();
        if (master != null && !(fs = master.tank.getFluid()).isEmpty()) {
            matrix.m_85836_();
            matrix.m_85837_(0.25, 0.875, (double)0.0025f);
            matrix.m_85841_(0.0625f, -0.0625f, 0.0625f);
            float h = (float)fs.getAmount() / (float)master.tank.getCapacity();
            GuiHelper.drawRepeatedFluidSprite((VertexConsumer)buffer.m_6299_(RenderType.m_110451_()), (PoseStack)matrix, (FluidStack)fs, (float)0.0f, (float)(0.0f + (1.0f - h) * 16.0f), (float)16.0f, (float)(h * 16.0f));
            matrix.m_85849_();
        }
        matrix.m_85849_();
        matrix.m_85836_();
        if (te.getIsMirrored()) {
            master = (OilTankTileEntity)te.master();
            if (master != null) {
                for (OilTankTileEntity.Port port : OilTankTileEntity.Port.DYNAMIC_PORTS) {
                    matrix.m_85836_();
                    BlockPos p = port.posInMultiblock.m_141950_((Vec3i)te.posInMultiblock);
                    matrix.m_85845_(new Quaternion(0.0f, 180.0f, 0.0f, true));
                    matrix.m_85837_((double)(p.m_123341_() - 1), (double)p.m_123342_(), (double)(-p.m_123343_() - 1));
                    this.quad(matrix, buffer, master.getPortStateFor(port), port.posInMultiblock.m_123341_() == 4, combinedLight, combinedOverlay);
                    matrix.m_85849_();
                }
            }
        } else {
            master = (OilTankTileEntity)te.master();
            if (master != null) {
                for (OilTankTileEntity.Port port : OilTankTileEntity.Port.DYNAMIC_PORTS) {
                    matrix.m_85836_();
                    BlockPos p = port.posInMultiblock.m_141950_((Vec3i)te.posInMultiblock);
                    matrix.m_85837_((double)p.m_123341_(), (double)p.m_123342_(), (double)p.m_123343_());
                    this.quad(matrix, buffer, master.getPortStateFor(port), port.posInMultiblock.m_123341_() == 4, combinedLight, combinedOverlay);
                    matrix.m_85849_();
                }
            }
        }
        matrix.m_85849_();
        matrix.m_85849_();
    }

    public void quad(PoseStack matrix, MultiBufferSource buffer, OilTankTileEntity.PortState portState, boolean flip, int combinedLight, int combinedOverlay) {
        Matrix4f mat = matrix.m_85850_().m_85861_();
        VertexConsumer builder = buffer.m_6299_(IPRenderTypes.OIL_TANK);
        boolean input = portState == OilTankTileEntity.PortState.INPUT;
        float u0 = input ? 0.0f : 0.1f;
        float v0 = 0.5f;
        float u1 = u0 + 0.1f;
        float v1 = v0 + 0.1f;
        if (flip) {
            builder.m_85982_(mat, 1.001f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u1, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
            builder.m_85982_(mat, 1.001f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u1, v0).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
            builder.m_85982_(mat, 1.001f, 1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u0, v0).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
            builder.m_85982_(mat, 1.001f, 0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u0, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        } else {
            builder.m_85982_(mat, -0.001f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u0, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
            builder.m_85982_(mat, -0.001f, 0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u1, v1).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
            builder.m_85982_(mat, -0.001f, 1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u1, v0).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
            builder.m_85982_(mat, -0.001f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u0, v0).m_86008_(combinedOverlay).m_85969_(combinedLight).m_5601_(1.0f, 1.0f, 1.0f).m_5752_();
        }
    }
}

