/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common;

import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import flaxbeard.immersivepetroleum.common.ReservoirRegionDataStorage;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class IPSaveData
extends SavedData {
    public static final String dataName = "ImmersivePetroleum-SaveData";
    private static IPSaveData INSTANCE;

    public IPSaveData() {
        INSTANCE = this;
    }

    public IPSaveData(CompoundTag nbt) {
        ListTag reservoirs;
        INSTANCE = this;
        ListTag lubricatedList = nbt.m_128437_("lubricated", 10);
        LubricatedHandler.lubricatedTiles.clear();
        for (int i = 0; i < lubricatedList.size(); ++i) {
            CompoundTag tag = lubricatedList.m_128728_(i);
            LubricatedHandler.LubricatedTileInfo info = new LubricatedHandler.LubricatedTileInfo(tag);
            LubricatedHandler.lubricatedTiles.add(info);
        }
        if (nbt.m_128425_("reservoirs", 9) && !(reservoirs = nbt.m_128437_("reservoirs", 10)).isEmpty()) {
            ReservoirRegionDataStorage storage = ReservoirRegionDataStorage.get();
            ImmersivePetroleum.log.debug("[ReservoirIslands]: Reading...");
            for (int i = 0; i < reservoirs.size(); ++i) {
                CompoundTag dim = reservoirs.m_128728_(i);
                ResourceLocation rl = new ResourceLocation(dim.m_128461_("dimension"));
                ResourceKey dimType = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)rl);
                ListTag islands = dim.m_128437_("islands", 10);
                List<ReservoirIsland> list = islands.stream().map(inbt -> ReservoirIsland.readFromNBT((CompoundTag)inbt)).filter(o -> o != null).collect(Collectors.toList());
                list.forEach(island -> storage.addIsland((ResourceKey<Level>)dimType, (ReservoirIsland)island));
                ImmersivePetroleum.log.debug("[ReservoirIslands]: Read {} islands for dim {}", (Object)list.size(), (Object)dimType.toString());
            }
            this.m_77762_();
        }
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag nbt) {
        ListTag lubricatedList = new ListTag();
        for (LubricatedHandler.LubricatedTileInfo info : LubricatedHandler.lubricatedTiles) {
            if (info == null) continue;
            CompoundTag tag = info.writeToNBT();
            lubricatedList.add((Object)tag);
        }
        nbt.m_128365_("lubricated", (Tag)lubricatedList);
        return nbt;
    }

    public static void markDirty() {
        if (INSTANCE != null) {
            INSTANCE.m_77762_();
        }
    }
}

