/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.change.changes;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.change.changes.IChange;
import mod.chiselsandbits.api.change.changes.IllegalChangeAttempt;
import mod.chiselsandbits.api.chiseling.conversion.IConversionManager;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.multistate.IMultiStateItem;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.variant.state.IStateVariant;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.multistate.snapshot.EmptySnapshot;
import mod.chiselsandbits.utils.BitInventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.Validate;

public class BitChange
implements IChange {
    private CompoundTag lazyLoadingTag;
    private BlockPos blockPos;
    private IMultiStateSnapshot before;
    private IMultiStateSnapshot after;

    public BitChange(BlockPos blockPos, IMultiStateSnapshot before, IMultiStateSnapshot after) {
        this.blockPos = blockPos;
        this.before = before;
        this.after = after;
    }

    public BitChange(Tag tag) {
        Validate.isInstanceOf(CompoundTag.class, (Object)tag);
        this.lazyLoadingTag = (CompoundTag)tag;
    }

    private void load() {
        if (this.lazyLoadingTag == null) {
            return;
        }
        this.deserializeNBT(this.lazyLoadingTag);
        this.lazyLoadingTag = null;
    }

    @Override
    public boolean canUndo(Player player) {
        this.load();
        BlockEntity tileEntity = player.f_19853_.m_7702_(this.blockPos);
        if (!(tileEntity instanceof IMultiStateBlockEntity)) {
            BlockState state = player.f_19853_.m_8055_(this.blockPos);
            Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(state, Optional.ofNullable(player.f_19853_.m_7702_(this.blockPos)));
            BlockInformation currentState = new BlockInformation(state, additionalStateInfo);
            return this.after.getStatics().getStateCounts().size() == 1 && this.after.getStatics().getStateCounts().getOrDefault(currentState, 0) == 4096;
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)tileEntity;
        return this.after.createNewShapeIdentifier().equals(multiStateBlockEntity.createNewShapeIdentifier()) && this.hasRequiredUndoBits(player);
    }

    @Override
    public boolean canRedo(Player player) {
        this.load();
        BlockEntity tileEntity = player.f_19853_.m_7702_(this.blockPos);
        if (!(tileEntity instanceof IMultiStateBlockEntity)) {
            BlockState state = player.f_19853_.m_8055_(this.blockPos);
            Optional<IStateVariant> additionalStateInfo = IStateVariantManager.getInstance().getStateVariant(state, Optional.ofNullable(player.f_19853_.m_7702_(this.blockPos)));
            BlockInformation currentState = new BlockInformation(state, additionalStateInfo);
            return this.before.getStatics().getStateCounts().size() == 1 && this.before.getStatics().getStateCounts().getOrDefault(currentState, 0) == 4096;
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)tileEntity;
        return this.before.createNewShapeIdentifier().equals(multiStateBlockEntity.createNewShapeIdentifier()) && this.hasRequiredRedoBits(player);
    }

    @Override
    public void undo(Player player) throws IllegalChangeAttempt {
        this.load();
        if (!this.canUndo(player)) {
            throw new IllegalChangeAttempt();
        }
        BlockEntity tileEntity = player.f_19853_.m_7702_(this.blockPos);
        if (!(tileEntity instanceof IMultiStateBlockEntity)) {
            BlockState currentState = player.f_19853_.m_8055_(this.blockPos);
            Optional<Block> convertedState = IConversionManager.getInstance().getChiseledVariantOf(currentState);
            if (convertedState.isEmpty()) {
                throw new IllegalChangeAttempt();
            }
            player.f_19853_.m_7731_(this.blockPos, convertedState.get().m_49966_(), 3);
            tileEntity = player.f_19853_.m_7702_(this.blockPos);
            if (!(tileEntity instanceof IMultiStateBlockEntity)) {
                throw new IllegalChangeAttempt();
            }
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)tileEntity;
        Map<BlockInformation, Integer> afterStates = this.after.getStatics().getStateCounts();
        Map<BlockInformation, Integer> beforeStates = this.before.getStatics().getStateCounts();
        HashMap difference = Maps.newHashMap();
        beforeStates.forEach((state, count) -> difference.put(state, afterStates.getOrDefault(state, 0) - count));
        afterStates.forEach((state, count) -> {
            if (!difference.containsKey(state)) {
                difference.put(state, count);
            }
        });
        try (IBatchMutation batch = multiStateBlockEntity.batch();){
            multiStateBlockEntity.initializeWith(BlockInformation.AIR);
            this.before.stream().forEach(iStateEntryInfo -> {
                try {
                    multiStateBlockEntity.setInAreaTarget(iStateEntryInfo.getBlockInformation(), iStateEntryInfo.getStartPoint());
                }
                catch (SpaceOccupiedException spaceOccupiedException) {
                    // empty catch block
                }
            });
        }
        if (!player.m_7500_()) {
            IBitInventory bitInventory = IBitInventoryManager.getInstance().create(player);
            difference.forEach((state, diff) -> {
                if (state.isAir()) {
                    return;
                }
                if (diff < 0) {
                    bitInventory.extract((BlockInformation)state, -diff.intValue());
                } else {
                    BitInventoryUtils.insertIntoOrSpawn(player, state, diff);
                }
            });
        }
    }

    @Override
    public void redo(Player player) throws IllegalChangeAttempt {
        this.load();
        if (!this.canRedo(player)) {
            throw new IllegalChangeAttempt();
        }
        BlockEntity tileEntity = player.f_19853_.m_7702_(this.blockPos);
        if (!(tileEntity instanceof IMultiStateBlockEntity)) {
            Optional<Block> convertedState;
            BlockState currentState;
            BlockState initializationState = currentState = player.f_19853_.m_8055_(this.blockPos);
            if (currentState.m_60795_()) {
                currentState = Blocks.f_50069_.m_49966_();
            }
            if ((convertedState = IConversionManager.getInstance().getChiseledVariantOf(currentState)).isEmpty()) {
                throw new IllegalChangeAttempt();
            }
            player.f_19853_.m_7731_(this.blockPos, convertedState.get().m_49966_(), 3);
            tileEntity = player.f_19853_.m_7702_(this.blockPos);
            if (!(tileEntity instanceof IMultiStateBlockEntity)) {
                throw new IllegalChangeAttempt();
            }
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)tileEntity;
        Map<BlockInformation, Integer> afterStates = this.after.getStatics().getStateCounts();
        Map<BlockInformation, Integer> beforeStates = this.before.getStatics().getStateCounts();
        HashMap difference = Maps.newHashMap();
        beforeStates.forEach((state, count) -> difference.put(state, count - afterStates.getOrDefault(state, 0)));
        afterStates.forEach((state, count) -> {
            if (!difference.containsKey(state)) {
                difference.put(state, -count.intValue());
            }
        });
        try (IBatchMutation batch = multiStateBlockEntity.batch();){
            multiStateBlockEntity.initializeWith(BlockInformation.AIR);
            this.after.stream().forEach(s -> {
                try {
                    multiStateBlockEntity.setInAreaTarget(s.getBlockInformation(), s.getStartPoint());
                }
                catch (SpaceOccupiedException spaceOccupiedException) {
                    // empty catch block
                }
            });
        }
        if (!player.m_7500_()) {
            IBitInventory bitInventory = IBitInventoryManager.getInstance().create(player);
            difference.forEach((state, diff) -> {
                if (diff < 0) {
                    bitInventory.extract((BlockInformation)state, -diff.intValue());
                } else {
                    BitInventoryUtils.insertIntoOrSpawn(player, state, diff);
                }
            });
        }
    }

    private boolean hasRequiredUndoBits(Player player) {
        if (player.m_7500_()) {
            return true;
        }
        Map<BlockInformation, Integer> afterStates = this.after.getStatics().getStateCounts();
        Map<BlockInformation, Integer> beforeStates = this.before.getStatics().getStateCounts();
        HashMap difference = Maps.newHashMap();
        beforeStates.forEach((state, count) -> difference.put(state, afterStates.getOrDefault(state, 0) - count));
        afterStates.forEach((state, count) -> {
            if (!difference.containsKey(state)) {
                difference.put(state, count);
            }
        });
        IBitInventory bitInventory = IBitInventoryManager.getInstance().create(player);
        return difference.entrySet().stream().filter(e -> (Integer)e.getValue() < 0).allMatch(e -> bitInventory.canExtract((BlockInformation)e.getKey(), -((Integer)e.getValue()).intValue()));
    }

    private boolean hasRequiredRedoBits(Player player) {
        if (player.m_7500_()) {
            return true;
        }
        Map<BlockInformation, Integer> afterStates = this.after.getStatics().getStateCounts();
        Map<BlockInformation, Integer> beforeStates = this.before.getStatics().getStateCounts();
        HashMap difference = Maps.newHashMap();
        beforeStates.forEach((state, count) -> difference.put(state, count - afterStates.getOrDefault(state, 0)));
        afterStates.forEach((state, count) -> {
            if (!difference.containsKey(state)) {
                difference.put(state, -count.intValue());
            }
        });
        IBitInventory bitInventory = IBitInventoryManager.getInstance().create(player);
        return difference.entrySet().stream().filter(e -> (Integer)e.getValue() < 0).allMatch(e -> bitInventory.canExtract((BlockInformation)e.getKey(), -((Integer)e.getValue()).intValue()));
    }

    @Override
    public CompoundTag serializeNBT() {
        if (this.lazyLoadingTag != null) {
            return this.lazyLoadingTag.m_6426_();
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)this.blockPos));
        tag.m_128365_("before", (Tag)this.before.toItemStack().toBlockStack().m_41739_(new CompoundTag()));
        tag.m_128365_("after", (Tag)this.after.toItemStack().toBlockStack().m_41739_(new CompoundTag()));
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.blockPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("pos"));
        this.before = BitChange.deserializeSnapshot(nbt.m_128469_("before"));
        this.after = BitChange.deserializeSnapshot(nbt.m_128469_("after"));
    }

    private static IMultiStateSnapshot deserializeSnapshot(CompoundTag nbt) {
        ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt);
        if (stack.m_41619_()) {
            return EmptySnapshot.INSTANCE;
        }
        if (!(stack.m_41720_() instanceof IMultiStateItem)) {
            return EmptySnapshot.INSTANCE;
        }
        return ((IMultiStateItem)stack.m_41720_()).createItemStack(stack).createSnapshot();
    }
}

