/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import java.util.List;
import mod.chiselsandbits.api.exceptions.SealingNotSupportedException;
import mod.chiselsandbits.api.item.pattern.IMultiUsePatternItem;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.pattern.placement.IPatternPlacementType;
import mod.chiselsandbits.api.sealing.ISupportsUnsealing;
import mod.chiselsandbits.api.util.HelpTextUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.item.SingleUsePatternItem;
import mod.chiselsandbits.registrars.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiUsePatternItem
extends SingleUsePatternItem
implements IMultiUsePatternItem {
    public MultiUsePatternItem(Item.Properties builder) {
        super(builder);
    }

    @Override
    protected InteractionResult determineSuccessResult(BlockPlaceContext context, ItemStack resultingStack) {
        return InteractionResult.SUCCESS;
    }

    @Override
    @NotNull
    public ItemStack seal(@NotNull ItemStack source) throws SealingNotSupportedException {
        throw new SealingNotSupportedException();
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        IPatternPlacementType mode = this.getMode(stack);
        if (mode.getGroup().isPresent()) {
            tooltip.add((Component)LocalStrings.PatternItemTooltipModeGrouped.getText(((IToolModeGroup)mode.getGroup().get()).getDisplayName(), mode.getDisplayName()));
        } else {
            tooltip.add((Component)LocalStrings.PatternItemTooltipModeSimple.getText(mode.getDisplayName()));
        }
        if (Minecraft.m_91087_().m_91268_() != null && Screen.m_96638_()) {
            tooltip.add((Component)new TextComponent("        "));
            tooltip.add((Component)new TextComponent("        "));
            HelpTextUtils.build(LocalStrings.HelpSealedPattern, tooltip, new Object[0]);
        }
    }

    @Override
    @NotNull
    public ItemStack unseal(@NotNull ItemStack source) throws SealingNotSupportedException {
        if (source.m_41720_() instanceof ISupportsUnsealing) {
            ItemStack seal = new ItemStack((ItemLike)ModItems.SINGLE_USE_PATTERN_ITEM.get());
            seal.m_41751_(source.m_41784_().m_6426_());
            return seal;
        }
        return source;
    }
}

