/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.keys;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.item.withmode.IWithModeItem;
import mod.chiselsandbits.client.reloading.ClientResourceReloadingManager;
import mod.chiselsandbits.client.screens.ToolModeSelectionScreen;
import mod.chiselsandbits.client.time.TickHandler;
import mod.chiselsandbits.keys.contexts.HoldsSpecificItemInHandKeyConflictContext;
import mod.chiselsandbits.keys.contexts.HoldsWithToolItemInHandKeyConflictContext;
import mod.chiselsandbits.keys.contexts.IsPressingDebugKeyConflictContext;
import mod.chiselsandbits.keys.contexts.SpecificScreenOpenKeyConflictContext;
import mod.chiselsandbits.network.packets.HeldToolModeChangedPacket;
import mod.chiselsandbits.network.packets.RequestChangeTrackerOperationPacket;
import mod.chiselsandbits.platforms.core.client.key.IKeyBindingManager;
import mod.chiselsandbits.platforms.core.client.key.KeyModifier;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.lwjgl.glfw.GLFW;

public class KeyBindingManager {
    private static final KeyBindingManager INSTANCE = new KeyBindingManager();
    private KeyMapping openToolMenuKeybinding = null;
    private KeyMapping cycleToolMenuLeftKeybinding = null;
    private KeyMapping cycleToolMenuRightKeybinding = null;
    private KeyMapping resetMeasuringTapeKeyBinding = null;
    private KeyMapping undoOperationKeyBinding = null;
    private KeyMapping redoOperationKeyBinding = null;
    private KeyMapping scopingKeyBinding = null;
    private KeyMapping resetCachesKeyBinding = null;
    private boolean toolMenuKeyWasDown = false;
    private int toolModeSelectionPlusCoolDown = 15;
    private int toolModeSelectionMinusCoolDown = 15;
    private long lastChangeTime = -10L;
    private boolean initialized = false;

    private KeyBindingManager() {
    }

    public static KeyBindingManager getInstance() {
        return INSTANCE;
    }

    public void onModInitialization() {
        this.openToolMenuKeybinding = IKeyBindingManager.getInstance().createNew("mod.chiselsandbits.keys.key.modded-tool.open", HoldsWithToolItemInHandKeyConflictContext.getInstance(), InputConstants.Type.KEYSYM, 82, "mod.chiselsandbits.keys.category");
        IKeyBindingManager.getInstance().register(this.openToolMenuKeybinding);
        this.cycleToolMenuLeftKeybinding = IKeyBindingManager.getInstance().createNew("mod.chiselsandbits.keys.key.modded-tool.cycle.left", SpecificScreenOpenKeyConflictContext.RADIAL_TOOL_MENU, InputConstants.Type.KEYSYM, InputConstants.f_84822_.m_84873_(), "mod.chiselsandbits.keys.category");
        IKeyBindingManager.getInstance().register(this.cycleToolMenuLeftKeybinding);
        this.cycleToolMenuRightKeybinding = IKeyBindingManager.getInstance().createNew("mod.chiselsandbits.keys.key.modded-tool.cycle.right", SpecificScreenOpenKeyConflictContext.RADIAL_TOOL_MENU, InputConstants.Type.KEYSYM, InputConstants.f_84822_.m_84873_(), "mod.chiselsandbits.keys.category");
        IKeyBindingManager.getInstance().register(this.cycleToolMenuRightKeybinding);
        this.resetMeasuringTapeKeyBinding = IKeyBindingManager.getInstance().createNew("mod.chiselsandbits.keys.key.measuring-tape.reset", HoldsSpecificItemInHandKeyConflictContext.MEASURING_TAPE, KeyModifier.CONTROL, InputConstants.Type.KEYSYM, 82, "mod.chiselsandbits.keys.category");
        IKeyBindingManager.getInstance().register(this.resetMeasuringTapeKeyBinding);
        this.undoOperationKeyBinding = IKeyBindingManager.getInstance().createNew("mod.chiselsandbits.keys.key.undo", HoldsSpecificItemInHandKeyConflictContext.CHANGE_TRACKING_ITEM, KeyModifier.CONTROL, InputConstants.Type.KEYSYM, 90, "mod.chiselsandbits.keys.category");
        IKeyBindingManager.getInstance().register(this.undoOperationKeyBinding);
        this.redoOperationKeyBinding = IKeyBindingManager.getInstance().createNew("mod.chiselsandbits.keys.key.redo", HoldsSpecificItemInHandKeyConflictContext.CHANGE_TRACKING_ITEM, KeyModifier.CONTROL, InputConstants.Type.KEYSYM, 89, "mod.chiselsandbits.keys.category");
        IKeyBindingManager.getInstance().register(this.redoOperationKeyBinding);
        this.scopingKeyBinding = IKeyBindingManager.getInstance().createNew("mod.chiselsandbits.keys.key.zoom", HoldsSpecificItemInHandKeyConflictContext.CHANGE_TRACKING_ITEM, InputConstants.Type.KEYSYM, 90, "mod.chiselsandbits.keys.category");
        IKeyBindingManager.getInstance().register(this.scopingKeyBinding);
        this.resetCachesKeyBinding = IKeyBindingManager.getInstance().createNew("mod.chiselsandbits.keys.reset-caches", IsPressingDebugKeyConflictContext.F3_DEBUG_KEY, InputConstants.Type.KEYSYM, 67, "mod.chiselsandbits.keys.category");
        IKeyBindingManager.getInstance().register(this.resetCachesKeyBinding);
        this.initialized = true;
    }

    public void handleKeyPresses() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ == null) {
            ItemStack inHand;
            boolean toolMenuKeyIsDown = this.isOpenToolMenuKeyPressed();
            if (toolMenuKeyIsDown && !this.toolMenuKeyWasDown && this.isOpenToolMenuKeyPressed() && mc.f_91080_ == null && !(inHand = ItemStackUtils.getModeItemStackFromPlayer((Player)mc.f_91074_)).m_41619_() && inHand.m_41720_() instanceof IWithModeItem) {
                try {
                    mc.m_91152_(ToolModeSelectionScreen.create(inHand));
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            this.toolMenuKeyWasDown = toolMenuKeyIsDown;
        } else {
            this.toolMenuKeyWasDown = true;
        }
        if (ItemStackUtils.getModeItemStackFromPlayer((Player)Minecraft.m_91087_().f_91074_).m_41720_() instanceof IWithModeItem) {
            ItemStack stack = ItemStackUtils.getModeItemStackFromPlayer((Player)Minecraft.m_91087_().f_91074_);
            IWithModeItem withModeItem = (IWithModeItem)stack.m_41720_();
            ArrayList candidates = Lists.newArrayList(withModeItem.getPossibleModes());
            Object cur = withModeItem.getMode(stack);
            int workingIndex = candidates.indexOf(cur);
            if (this.toolModeSelectionPlusCoolDown == 15 && this.isCycleToolMenuRightKeyPressed()) {
                if (++workingIndex >= candidates.size()) {
                    workingIndex = 0;
                }
                ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new HeldToolModeChangedPacket(workingIndex));
                this.toolModeSelectionPlusCoolDown = 0;
            } else if (this.isCycleToolMenuRightKeyPressed() && this.toolModeSelectionPlusCoolDown <= 14) {
                ++this.toolModeSelectionPlusCoolDown;
            } else if (this.toolModeSelectionMinusCoolDown == 15 && this.isCycleToolMenuLeftKeyPressed()) {
                if (--workingIndex < 0) {
                    workingIndex = candidates.size() - 1;
                }
                ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new HeldToolModeChangedPacket(workingIndex));
                this.toolModeSelectionMinusCoolDown = 0;
            } else if (this.isCycleToolMenuLeftKeyPressed() && this.toolModeSelectionMinusCoolDown <= 14) {
                ++this.toolModeSelectionMinusCoolDown;
            }
        }
        if (!this.isCycleToolMenuRightKeyPressed()) {
            this.toolModeSelectionPlusCoolDown = 15;
        }
        if (!this.isCycleToolMenuLeftKeyPressed()) {
            this.toolModeSelectionMinusCoolDown = 15;
        }
        if (this.isUndoOperationKeyPressed() && TickHandler.getClientTicks() - this.lastChangeTime > 10L) {
            ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new RequestChangeTrackerOperationPacket(false));
            this.lastChangeTime = TickHandler.getClientTicks();
        }
        if (this.isRedoOperationKeyPressed() && TickHandler.getClientTicks() - this.lastChangeTime > 10L) {
            ChiselsAndBits.getInstance().getNetworkChannel().sendToServer(new RequestChangeTrackerOperationPacket(true));
            this.lastChangeTime = TickHandler.getClientTicks();
        }
        if (this.isResetCachesPressed()) {
            ClientResourceReloadingManager.getInstance().clearCaches();
        }
    }

    public boolean hasBeenInitialized() {
        return this.initialized;
    }

    public boolean isOpenToolMenuKeyPressed() {
        return this.isKeyDown(this.getOpenToolMenuKeybinding());
    }

    public boolean isCycleToolMenuRightKeyPressed() {
        return this.isKeyDown(this.getCycleToolMenuRightKeybinding());
    }

    public boolean isCycleToolMenuLeftKeyPressed() {
        return this.isKeyDown(this.getCycleToolMenuLeftKeybinding());
    }

    public boolean isUndoOperationKeyPressed() {
        return this.isKeyDown(this.getUndoOperationKeyBinding());
    }

    public boolean isRedoOperationKeyPressed() {
        return this.isKeyDown(this.getRedoOperationKeyBinding());
    }

    public boolean isKeyDown(KeyMapping keybinding) {
        if (keybinding.m_90862_()) {
            return false;
        }
        boolean isDown = switch (keybinding.f_90816_.m_84868_()) {
            case InputConstants.Type.KEYSYM -> InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keybinding.f_90816_.m_84873_());
            case InputConstants.Type.MOUSE -> {
                if (GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)keybinding.f_90816_.m_84873_()) == 1) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
        return (isDown || keybinding.m_90857_()) && IKeyBindingManager.getInstance().isKeyConflictOfActive(keybinding) && IKeyBindingManager.getInstance().isKeyModifierActive(keybinding);
    }

    public KeyMapping getOpenToolMenuKeybinding() {
        if (this.openToolMenuKeybinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.openToolMenuKeybinding;
    }

    public KeyMapping getCycleToolMenuRightKeybinding() {
        if (this.cycleToolMenuRightKeybinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.cycleToolMenuRightKeybinding;
    }

    public KeyMapping getCycleToolMenuLeftKeybinding() {
        if (this.cycleToolMenuLeftKeybinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.cycleToolMenuLeftKeybinding;
    }

    public KeyMapping getUndoOperationKeyBinding() {
        if (this.undoOperationKeyBinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.undoOperationKeyBinding;
    }

    public KeyMapping getRedoOperationKeyBinding() {
        if (this.redoOperationKeyBinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.redoOperationKeyBinding;
    }

    public boolean isResetMeasuringTapeKeyPressed() {
        return this.isKeyDown(this.getResetMeasuringTapeKeyBinding());
    }

    public KeyMapping getResetMeasuringTapeKeyBinding() {
        if (this.resetMeasuringTapeKeyBinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.resetMeasuringTapeKeyBinding;
    }

    public KeyMapping getScopingKeyBinding() {
        if (this.scopingKeyBinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.scopingKeyBinding;
    }

    public boolean isScopingKeyPressed() {
        return this.isKeyDown(this.getScopingKeyBinding());
    }

    public KeyMapping getResetCachesKeyBinding() {
        if (this.resetCachesKeyBinding == null) {
            throw new IllegalStateException("Keybindings have not been initialized.");
        }
        return this.resetCachesKeyBinding;
    }

    public boolean isResetCachesPressed() {
        return this.isKeyDown(this.getResetCachesKeyBinding());
    }
}

