/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.platforms.core.registries.deferred.impl.custom;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mod.chiselsandbits.platforms.core.registries.IChiselsAndBitsRegistry;
import mod.chiselsandbits.platforms.core.registries.IChiselsAndBitsRegistryEntry;
import mod.chiselsandbits.platforms.core.registries.deferred.IRegistryObject;
import mod.chiselsandbits.platforms.core.registries.deferred.impl.custom.EmptyCustomRegistryObject;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CustomRegistryObject<T extends R, R extends IChiselsAndBitsRegistryEntry>
implements IRegistryObject<T> {
    private final ResourceLocation entryName;
    private final Supplier<IChiselsAndBitsRegistry<R>> registry;

    public CustomRegistryObject(ResourceLocation name, Supplier<IChiselsAndBitsRegistry<R>> registry) {
        this.entryName = name;
        this.registry = registry;
    }

    private CustomRegistryObject(T entry, Supplier<IChiselsAndBitsRegistry<R>> registry) {
        this.entryName = entry.getRegistryName();
        this.registry = registry;
    }

    @Override
    @NotNull
    public T get() {
        return (T)((IChiselsAndBitsRegistryEntry)this.getEntry().orElse(null));
    }

    private Optional<T> getEntry() {
        return this.registry.get().get(this.entryName);
    }

    @Override
    public ResourceLocation getId() {
        return this.entryName;
    }

    @Override
    public Stream<T> stream() {
        return this.getEntry().stream();
    }

    @Override
    public boolean isPresent() {
        return this.getEntry().isPresent();
    }

    @Override
    public void ifPresent(Consumer<? super T> consumer) {
        this.getEntry().ifPresent(consumer);
    }

    @Override
    public IRegistryObject<T> filter(Predicate<? super T> predicate) {
        return this.getEntry().filter(predicate).map(entry -> new CustomRegistryObject<IChiselsAndBitsRegistryEntry, R>((IChiselsAndBitsRegistryEntry)entry, this.registry)).orElseGet(new EmptyCustomRegistryObject());
    }

    @Override
    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        return this.getEntry().map(mapper);
    }

    @Override
    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        return this.getEntry().flatMap(mapper);
    }

    @Override
    public <U> Supplier<U> lazyMap(Function<? super T, ? extends U> mapper) {
        return () -> this.getEntry().map(mapper).orElse(null);
    }

    @Override
    public T orElse(T other) {
        return (T)((IChiselsAndBitsRegistryEntry)this.getEntry().orElse(other));
    }

    @Override
    public T orElseGet(Supplier<? extends T> other) {
        return (T)((IChiselsAndBitsRegistryEntry)this.getEntry().orElseGet(other));
    }

    @Override
    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return (T)((IChiselsAndBitsRegistryEntry)this.getEntry().orElseThrow(exceptionSupplier));
    }
}

