/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.stateinfo.additional;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.variant.state.IStateVariant;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.api.variant.state.IStateVariantProvider;
import mod.chiselsandbits.platforms.core.fluid.FluidInformation;
import mod.chiselsandbits.platforms.core.registries.IPlatformRegistryManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public final class StateVariantManager
implements IStateVariantManager {
    private static final StateVariantManager INSTANCE = new StateVariantManager();
    private final Map<Block, IStateVariantProvider> providers = new ConcurrentHashMap<Block, IStateVariantProvider>();

    public static StateVariantManager getInstance() {
        return INSTANCE;
    }

    private StateVariantManager() {
    }

    @Override
    public Optional<IStateVariant> getStateVariant(BlockState blockState, Optional<BlockEntity> blockEntity) {
        if (!this.providers.containsKey(blockState.m_60734_())) {
            return Optional.empty();
        }
        return Optional.of(this.providers.get(blockState.m_60734_())).flatMap(provider -> provider.getStateVariant(blockState, blockEntity)).map(variant -> new WrappingStateVariant(blockState.m_60734_(), (IStateVariant)variant));
    }

    @Override
    public Optional<IStateVariant> getStateVariant(FluidState fluidStateIn) {
        if (!this.providers.containsKey(fluidStateIn.m_76188_().m_60734_())) {
            return Optional.empty();
        }
        return Optional.of(this.providers.get(fluidStateIn.m_76188_().m_60734_())).flatMap(provider -> provider.getStateVariant(fluidStateIn)).map(variant -> new WrappingStateVariant(fluidStateIn.m_76188_().m_60734_(), (IStateVariant)variant));
    }

    @Override
    public Optional<IStateVariant> getStateVariant(BlockState blockState, ItemStack itemStack) {
        if (!this.providers.containsKey(blockState.m_60734_())) {
            return Optional.empty();
        }
        return Optional.of(this.providers.get(blockState.m_60734_())).flatMap(provider -> provider.getStateVariant(blockState, itemStack)).map(variant -> new WrappingStateVariant(blockState.m_60734_(), (IStateVariant)variant));
    }

    @Override
    public Optional<IStateVariant> getStateVariant(FluidInformation fluidInformation) {
        if (!this.providers.containsKey(fluidInformation.fluid().m_76145_().m_76188_().m_60734_())) {
            return Optional.empty();
        }
        return Optional.of(this.providers.get(fluidInformation.fluid().m_76145_().m_76188_().m_60734_())).flatMap(provider -> provider.getStateVariant(fluidInformation)).map(variant -> new WrappingStateVariant(fluidInformation.fluid().m_76145_().m_76188_().m_60734_(), (IStateVariant)variant));
    }

    @Override
    public Collection<BlockInformation> getAllDefaultVariants(BlockState state) {
        if (!this.providers.containsKey(state.m_60734_())) {
            return Collections.emptyList();
        }
        return Optional.of(this.providers.get(state.m_60734_())).map(provider -> provider.getAllDefaultVariants(state)).stream().flatMap(Collection::stream).map(variant -> new WrappingStateVariant(state.m_60734_(), (IStateVariant)variant)).map(variant -> new BlockInformation(state, Optional.ofNullable(variant))).collect(Collectors.toSet());
    }

    @Override
    public CompoundTag serializeNBT(IStateVariant additionalStateInfo) {
        if (!(additionalStateInfo instanceof WrappingStateVariant)) {
            throw new IllegalArgumentException("additionalStateInfo must be a WrappingStateVariant");
        }
        WrappingStateVariant wrappingStateVariant = (WrappingStateVariant)additionalStateInfo;
        Block block = wrappingStateVariant.getSourceBlock();
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("block", IPlatformRegistryManager.getInstance().getBlockRegistry().getKey(block).toString());
        tag.m_128365_("variant", (Tag)this.providers.get(block).serializeNBT(wrappingStateVariant.getDelegate()));
        return tag;
    }

    @Override
    public IStateVariant deserializeNBT(CompoundTag tag) {
        Optional<Block> block = IPlatformRegistryManager.getInstance().getBlockRegistry().getValue(new ResourceLocation(tag.m_128461_("block")));
        if (block.isEmpty()) {
            throw new IllegalStateException("Missing block from variant!");
        }
        IStateVariant delegate = this.providers.get(block.get()).deserializeNBT(tag.m_128469_("variant"));
        return new WrappingStateVariant(block.get(), delegate);
    }

    @Override
    public void serializeInto(FriendlyByteBuf packetBuffer, IStateVariant info) {
        if (!(info instanceof WrappingStateVariant)) {
            throw new IllegalArgumentException("additionalStateInfo must be a WrappingStateVariant");
        }
        WrappingStateVariant wrappingStateVariant = (WrappingStateVariant)info;
        packetBuffer.m_130085_(IPlatformRegistryManager.getInstance().getBlockRegistry().getKey(wrappingStateVariant.getSourceBlock()));
        this.providers.get(wrappingStateVariant.getSourceBlock()).serializeInto(packetBuffer, wrappingStateVariant.getDelegate());
    }

    @Override
    public IStateVariant deserializeFrom(FriendlyByteBuf packetBuffer) {
        Optional<Block> block = IPlatformRegistryManager.getInstance().getBlockRegistry().getValue(packetBuffer.m_130281_());
        if (block.isEmpty()) {
            throw new IllegalStateException("Missing block from variant!");
        }
        IStateVariant stateVariant = this.providers.get(block.get()).deserializeFrom(packetBuffer);
        return new WrappingStateVariant(block.get(), stateVariant);
    }

    @Override
    public Optional<ItemStack> getItemStack(BlockInformation blockInformation) {
        if (!this.providers.containsKey(blockInformation.getBlockState().m_60734_())) {
            return Optional.empty();
        }
        return this.providers.get(blockInformation.getBlockState().m_60734_()).getItemStack(blockInformation.getVariant());
    }

    @Override
    public Optional<FluidInformation> getFluidInformation(BlockInformation state, long amount) {
        if (!this.providers.containsKey(state.getBlockState().m_60734_())) {
            return Optional.empty();
        }
        return this.providers.get(state.getBlockState().m_60734_()).getFluidInformation(state.getVariant(), amount);
    }

    private static final class WrappingStateVariant
    implements IStateVariant {
        private static final Comparator<IStateVariant> VARIANT_COMPARATOR = Comparator.comparing(variant -> variant.getClass().getName()).thenComparing(Comparator.naturalOrder());
        private final Block sourceBlock;
        private final IStateVariant delegate;

        private WrappingStateVariant(Block sourceBlock, IStateVariant delegate) {
            this.sourceBlock = sourceBlock;
            this.delegate = delegate;
        }

        @Override
        public int compareTo(@NotNull IStateVariant o) {
            if (o instanceof WrappingStateVariant) {
                WrappingStateVariant wrappingStateVariant = (WrappingStateVariant)o;
                return VARIANT_COMPARATOR.compare(this.delegate, wrappingStateVariant.delegate);
            }
            return -1;
        }

        @Override
        public IStateVariant createSnapshot() {
            return new WrappingStateVariant(this.sourceBlock, (IStateVariant)this.delegate.createSnapshot());
        }

        public Block getSourceBlock() {
            return this.sourceBlock;
        }

        public IStateVariant getDelegate() {
            return this.delegate;
        }
    }
}

