/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.storage;

import java.util.LinkedList;
import java.util.concurrent.Executor;
import mod.chiselsandbits.storage.ILegacyStorageHandler;
import mod.chiselsandbits.storage.IMultiThreadedStorageEngine;
import mod.chiselsandbits.storage.IStorageHandler;
import mod.chiselsandbits.storage.IThreadAwareStorageEngine;
import mod.chiselsandbits.storage.LegacyAwareStorageEngine;
import mod.chiselsandbits.storage.LegacyVersionedStorageEngine;
import mod.chiselsandbits.storage.MultiThreadAwareStorageEngine;
import mod.chiselsandbits.storage.VersionedStorageEngine;

public class StorageEngineBuilder {
    private final LinkedList<ILegacyStorageHandler> legacyStorageHandlers = new LinkedList();
    private final LinkedList<IStorageHandler> storageHandlers = new LinkedList();
    private int minimalVersion = 0;

    public static StorageEngineBuilder create() {
        return new StorageEngineBuilder();
    }

    private StorageEngineBuilder() {
    }

    public StorageEngineBuilder withLegacy(ILegacyStorageHandler handler) {
        this.legacyStorageHandlers.add(handler);
        return this;
    }

    public StorageEngineBuilder minimalVersion(int version) {
        this.minimalVersion = version;
        return this;
    }

    public StorageEngineBuilder with(IStorageHandler handler) {
        this.storageHandlers.add(handler);
        return this;
    }

    public IThreadAwareStorageEngine build() {
        return new LegacyAwareStorageEngine(new LegacyVersionedStorageEngine(this.legacyStorageHandlers), new VersionedStorageEngine(this.minimalVersion, this.storageHandlers));
    }

    public IMultiThreadedStorageEngine buildMultiThreaded(Executor gameExecutor) {
        return new MultiThreadAwareStorageEngine(gameExecutor, this.build());
    }
}

