/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.mrh0.createaddition.CreateAddition;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyManager;
import com.mrh0.createaddition.index.CAItems;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.condition.CargoThresholdCondition;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyThresholdCondition
extends CargoThresholdCondition {
    protected Component getUnit() {
        return Components.literal((String)"Kfe");
    }

    protected ItemStack getIcon() {
        return CAItems.CAPACITOR.asStack();
    }

    public ItemStack getSecondLineIcon() {
        return CAItems.CAPACITOR.asStack();
    }

    public int slotsTargeted() {
        return 0;
    }

    public boolean lazyTickCompletion(Level level, Train train, CompoundTag context) {
        return this.test(level, train, context);
    }

    protected boolean test(Level level, Train train, CompoundTag context) {
        CargoThresholdCondition.Ops operator = this.getOperator();
        int target = this.getThreshold();
        int foundEnergy = 0;
        for (Carriage carriage : train.carriages) {
            IEnergyStorage ies;
            if (carriage.anyAvailableEntity() == null || (ies = PortableEnergyManager.get(carriage.anyAvailableEntity().getContraption())) == null) continue;
            foundEnergy += ies.getEnergyStored();
        }
        this.requestStatusToUpdate(foundEnergy / 1000, context);
        return operator.test(foundEnergy, target * 1000);
    }

    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)Lang.translateDirect((String)"schedule.condition.threshold.train_holds", (Object[])new Object[]{Lang.translateDirect((String)("schedule.condition.threshold." + Lang.asId((String)this.getOperator().name())), (Object[])new Object[0])}), (Object)Lang.translateDirect((String)"schedule.condition.threshold.x_units_of_item", (Object[])new Object[]{this.getThreshold(), new TranslatableComponent("createaddition.schedule.condition.threshold.unit"), new TranslatableComponent("createaddition.schedule.condition.threshold.energy")}).m_130940_(ChatFormatting.DARK_AQUA));
    }

    public ResourceLocation getId() {
        return CreateAddition.asResource("energy_threshold");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        super.initConfigurationWidgets(builder);
        builder.addSelectionScrollInput(71, 50, (i, l) -> i.forOptions((List)ImmutableList.of((Object)new TranslatableComponent("createaddition.schedule.condition.threshold.unit"))).titled(null), "Measure");
    }

    public MutableComponent getWaitingStatus(Level level, Train train, CompoundTag tag) {
        int lastDisplaySnapshot = this.getLastDisplaySnapshot(tag);
        if (lastDisplaySnapshot == -1) {
            return Components.empty();
        }
        int offset = this.getOperator() == CargoThresholdCondition.Ops.LESS ? -1 : (this.getOperator() == CargoThresholdCondition.Ops.GREATER ? 1 : 0);
        return Lang.translateDirect((String)"schedule.condition.threshold.status", (Object[])new Object[]{lastDisplaySnapshot, Math.max(0, this.getThreshold() + offset), new TranslatableComponent("createaddition.schedule.condition.threshold.unit")});
    }
}

