/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.disenchanter;

import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.Pair;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.disenchanter.DisenchantRecipe;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.disenchanter.DisenchanterBlockEntity;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience.ExperienceFluid;
import plus.dragons.createenchantmentindustry.entry.CeiFluids;
import plus.dragons.createenchantmentindustry.entry.CeiRecipeTypes;

public class Disenchanting {
    private static final RecipeWrapper WRAPPER = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));

    public static ItemStack disenchantAndInsert(DisenchanterBlockEntity be, ItemStack itemStack, boolean simulate) {
        Level level = be.m_58904_();
        if (level == null) {
            return itemStack;
        }
        WRAPPER.m_6836_(0, itemStack);
        return CeiRecipeTypes.DISENCHANTING.find(WRAPPER, be.m_58904_()).map(recipe -> {
            if (!recipe.hasNoResult()) {
                return itemStack;
            }
            SmartFluidTankBehaviour tank = be.getInternalTank();
            tank.allowInsertion();
            int amount = recipe.getExperience();
            FluidStack fluidStack = new FluidStack(((ExperienceFluid)CeiFluids.EXPERIENCE.get()).m_5613_(), itemStack.m_41613_() * amount);
            int inserted = tank.getPrimaryHandler().fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) / amount;
            ItemStack ret = itemStack.m_41777_();
            if (!simulate) {
                fluidStack = new FluidStack(((ExperienceFluid)CeiFluids.EXPERIENCE.get()).m_5613_(), inserted * amount);
                tank.getPrimaryHandler().fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            }
            ret.m_41774_(inserted);
            tank.forbidInsertion();
            return ret;
        }).orElse(itemStack);
    }

    @Nullable
    public static Pair<FluidStack, ItemStack> disenchantResult(ItemStack itemStack, Level level) {
        if (EnchantmentHelper.m_44831_((ItemStack)itemStack).keySet().stream().anyMatch(enchantment -> !enchantment.m_6589_())) {
            FluidStack xp = new FluidStack(((ExperienceFluid)CeiFluids.EXPERIENCE.get()).m_5613_(), Disenchanting.getDisenchantExperience(itemStack));
            ItemStack result = Disenchanting.disenchant(itemStack);
            return Pair.of((Object)xp, (Object)result);
        }
        WRAPPER.m_6836_(0, itemStack);
        DisenchantRecipe recipe = CeiRecipeTypes.DISENCHANTING.find(WRAPPER, level).orElse(null);
        if (recipe != null && !recipe.hasNoResult()) {
            FluidStack xp = new FluidStack(((ExperienceFluid)CeiFluids.EXPERIENCE.get()).m_5613_(), recipe.getExperience());
            ItemStack result = recipe.m_8043_().m_41777_();
            return Pair.of((Object)xp, (Object)result);
        }
        return null;
    }

    public static ItemStack disenchant(ItemStack itemStack) {
        ItemStack result = itemStack.m_41777_();
        result.m_41749_("Enchantments");
        result.m_41749_("StoredEnchantments");
        Map<Enchantment, Integer> curses = EnchantmentHelper.m_44831_((ItemStack)itemStack).entrySet().stream().filter(entry -> ((Enchantment)entry.getKey()).m_6589_()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (result.m_150930_(Items.f_42690_) && curses.isEmpty()) {
            CompoundTag tag = result.m_41783_();
            result = new ItemStack((ItemLike)Items.f_42517_);
            if (tag != null) {
                tag.m_128473_("RepairCost");
            }
            result.m_41751_(tag);
        } else {
            EnchantmentHelper.m_44865_(curses, (ItemStack)result);
            result.m_41742_(0);
            for (int i = 0; i < curses.size(); ++i) {
                result.m_41742_(AnvilMenu.m_39025_((int)result.m_41610_()));
            }
        }
        return result;
    }

    private static int getDisenchantExperience(ItemStack itemStack) {
        int xp = EnchantmentHelper.m_44831_((ItemStack)itemStack).entrySet().stream().filter(entry -> !((Enchantment)entry.getKey()).m_6589_()).map(entry -> ((Enchantment)entry.getKey()).m_6183_(((Integer)entry.getValue()).intValue())).reduce(0, Integer::sum);
        return xp == 0 ? 0 : Mth.m_14165_((double)((double)xp * 0.75));
    }
}

