/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.entry;

import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateItemTagsProvider;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;
import plus.dragons.createenchantmentindustry.EnchantmentIndustry;

public interface CeiTags<T, P extends RegistrateTagsProvider<T>> {
    public static final ITagManager<Block> BLOCK_TAGS = Objects.requireNonNull(ForgeRegistries.BLOCKS.tags());
    public static final ITagManager<Item> ITEM_TAGS = Objects.requireNonNull(ForgeRegistries.ITEMS.tags());
    public static final ITagManager<Fluid> FLUID_TAGS = Objects.requireNonNull(ForgeRegistries.FLUIDS.tags());
    public static final String FORGE = "forge";
    public static final String CREATE = "create";

    public TagKey<T> tag();

    public boolean hasDatagen();

    default public void datagen(P pov) {
    }

    public static String toTagName(String enumName) {
        return enumName.replace('$', '/').toLowerCase(Locale.ROOT);
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOrPickaxe() {
        return b -> b.tag(new TagKey[]{BlockTags.f_144280_}).tag(new TagKey[]{BlockTags.f_144282_});
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOnly() {
        return b -> b.tag(new TagKey[]{BlockTags.f_144280_});
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> pickaxeOnly() {
        return b -> b.tag(new TagKey[]{BlockTags.f_144282_});
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, ItemBuilder<BlockItem, BlockBuilder<T, P>>> tagBlockAndItem(String namespace, String ... paths) {
        return block -> {
            ItemBuilder item = block.item();
            for (String path : paths) {
                block.tag(new TagKey[]{BLOCK_TAGS.createTagKey(new ResourceLocation(namespace, path))});
                item.tag(new TagKey[]{ITEM_TAGS.createTagKey(new ResourceLocation(namespace, path))});
            }
            return item;
        };
    }

    public static void register() {
        CreateRegistrate registrate = EnchantmentIndustry.registrate();
        Arrays.stream(BlockTag.values()).filter(CeiTags::hasDatagen).forEach(tag -> registrate.addDataGenerator(ProviderType.BLOCK_TAGS, tag::datagen));
        Arrays.stream(ItemTag.values()).filter(CeiTags::hasDatagen).forEach(tag -> registrate.addDataGenerator(ProviderType.ITEM_TAGS, tag::datagen));
        Arrays.stream(FluidTag.values()).filter(CeiTags::hasDatagen).forEach(tag -> registrate.addDataGenerator(ProviderType.FLUID_TAGS, tag::datagen));
    }

    public static final class BlockTag
    extends Enum<BlockTag>
    implements CeiTags<Block, RegistrateTagsProvider<Block>> {
        final TagKey<Block> tag;
        final boolean datagen;
        private static final /* synthetic */ BlockTag[] $VALUES;

        public static BlockTag[] values() {
            return (BlockTag[])$VALUES.clone();
        }

        public static BlockTag valueOf(String name) {
            return Enum.valueOf(BlockTag.class, name);
        }

        private BlockTag(String namespace, boolean datagen) {
            this.tag = BLOCK_TAGS.createTagKey(new ResourceLocation(namespace, CeiTags.toTagName(this.name())));
            this.datagen = datagen;
        }

        private BlockTag(boolean datagen) {
            this("create_enchantment_industry", datagen);
        }

        @Override
        public TagKey<Block> tag() {
            return this.tag;
        }

        @Override
        public boolean hasDatagen() {
            return this.datagen;
        }

        private static /* synthetic */ BlockTag[] $values() {
            return new BlockTag[0];
        }

        static {
            $VALUES = BlockTag.$values();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ItemTag implements CeiTags<Item, RegistrateItemTagsProvider>
    {
        INK_INGREDIENT(true){

            @Override
            public void datagen(RegistrateItemTagsProvider pov) {
                pov.m_206424_(this.tag).m_126584_((Object[])new Item[]{Items.f_42498_, Items.f_41951_, Items.f_42532_});
            }
        }
        ,
        UPRIGHT_ON_BELT("create", true){

            @Override
            public void datagen(RegistrateItemTagsProvider pov) {
                pov.m_206424_(this.tag).m_126582_((Object)Items.f_42612_);
            }
        };

        final TagKey<Item> tag;
        final boolean datagen;

        private ItemTag(String namespace, boolean datagen) {
            this.tag = ITEM_TAGS.createTagKey(new ResourceLocation(namespace, CeiTags.toTagName(this.name())));
            this.datagen = datagen;
        }

        private ItemTag(boolean datagen) {
            this("create_enchantment_industry", datagen);
        }

        @Override
        public TagKey<Item> tag() {
            return this.tag;
        }

        @Override
        public boolean hasDatagen() {
            return this.datagen;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum FluidTag implements CeiTags<Fluid, RegistrateTagsProvider<Fluid>>
    {
        INK("forge", false),
        BLAZE_ENCHANTER_INPUT(false),
        PRINTER_INPUT(true){

            @Override
            public void datagen(RegistrateTagsProvider<Fluid> pov) {
                pov.m_206424_(this.tag).m_206428_(1.INK.tag);
            }
        };

        final TagKey<Fluid> tag;
        final boolean datagen;

        private FluidTag(String namespace, boolean datagen) {
            this.tag = FLUID_TAGS.createTagKey(new ResourceLocation(namespace, CeiTags.toTagName(this.name())));
            this.datagen = datagen;
        }

        private FluidTag(boolean datagen) {
            this("create_enchantment_industry", datagen);
        }

        @Override
        public TagKey<Fluid> tag() {
            return this.tag;
        }

        @Override
        public boolean hasDatagen() {
            return this.datagen;
        }
    }
}

